/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.gui.layers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.items.relics.back.LeafyMantleItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import it.hurts.sskirillss.relics.utils.data.SpriteMirror;
import java.awt.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;

public class LeafyMantleHideLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/leafy_mantle_hide.png");
    private static final ResourceLocation VIGNETTE = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LeafyMantleItem relic;
        Minecraft MC = Minecraft.getInstance();
        LocalPlayer player = MC.player;
        if (player == null) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)RelicsItems.LEAFY_MANTLE.get());
        Item item = stack.getItem();
        if (!(item instanceof LeafyMantleItem) || !(relic = (LeafyMantleItem)item).isAbilityRankModifierUnlocked((LivingEntity)player, stack, "camouflage", "disappearance")) {
            return;
        }
        int progress = relic.getCurrentProgress(stack);
        if (progress <= 0) {
            return;
        }
        int maxProgress = relic.getMaxProgress();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        float progressRatio = (float)TransitionType.QUAD.apply(EaseType.EASE_IN_OUT, (double)Math.min(1.0f, ((float)progress + partialTick * (float)(relic.isHiding(stack) ? 1 : -1)) / (float)maxProgress));
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Window window = MC.getWindow();
        int width = window.getGuiScaledWidth();
        int height = window.getGuiScaledHeight();
        int texWidth = 89;
        int texHeight = 62;
        float alpha = progressRatio * 0.75f;
        float offsetX = (float)texWidth * (1.0f - progressRatio);
        float offsetY = (float)texHeight * (1.0f - progressRatio);
        Color color = new Color(BiomeColors.getAverageGrassColor((BlockAndTintGetter)player.level(), (BlockPos)player.blockPosition())).brighter();
        RenderSystem.enableBlend();
        GUIRenderer.begin(VIGNETTE, poseStack).anchor(SpriteAnchor.TOP_LEFT).patternSize(width, height).texSize(width, height).color(color).alpha(alpha * 0.25f).end();
        GUIRenderer.begin(TEXTURE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(-offsetX, -offsetY).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos((float)width + offsetX, -offsetY).mirror(SpriteMirror.HORIZONTAL).anchor(SpriteAnchor.TOP_RIGHT).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos(-offsetX, (float)height + offsetY).anchor(SpriteAnchor.BOTTOM_LEFT).mirror(SpriteMirror.VERTICAL).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos((float)width + offsetX, (float)height + offsetY).mirror(SpriteMirror.HORIZONTAL, SpriteMirror.VERTICAL).anchor(SpriteAnchor.BOTTOM_RIGHT).color(color).alpha(alpha).scale(2.0f).end();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

