/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.gui.layers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.items.relics.head.PiglinMaskItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import it.hurts.sskirillss.relics.utils.data.SpriteMirror;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PiglinMaskTeethLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation TOOTH = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/layer/piglin_mask/tooth.png");
    private static final ResourceLocation GUM = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/layer/piglin_mask/gum.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft MC = Minecraft.getInstance();
        LocalPlayer player = MC.player;
        if (player == null) {
            return;
        }
        int stacks = 0;
        int duration = 0;
        int maxDuration = 0;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)RelicsItems.PIGLIN_MASK.get())) {
            PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
            if (relic.getStacks(stack) > stacks) {
                stacks = relic.getStacks(stack);
            }
            if (relic.getDuration(stack) > duration) {
                duration = relic.getDuration(stack);
            }
            if (relic.getMaxDuration((LivingEntity)player, stack) <= maxDuration) continue;
            maxDuration = relic.getMaxDuration((LivingEntity)player, stack);
        }
        if (stacks <= 0) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(true);
        int maxStacks = PiglinMaskItem.getMaxStacks();
        poseStack.pushPose();
        Window window = MC.getWindow();
        RenderSystem.enableBlend();
        int maxHeight = window.getGuiScaledHeight();
        int maxWidth = window.getGuiScaledWidth();
        int height = 21;
        int width = 24;
        int yOff = 0;
        float progress = (float)stacks / (float)maxStacks;
        float alpha = stacks >= maxStacks ? ((float)duration > (float)maxDuration * 0.25f ? 1.0f : (float)duration / ((float)maxDuration * 0.25f)) : 1.0f;
        int i = 0;
        while ((double)i < Math.ceil((double)maxHeight / (double)height)) {
            poseStack.pushPose();
            poseStack.translate((float)(-width) + (float)width * progress, 0.0f, 0.0f);
            GUIRenderer.begin(GUM, poseStack).pos(0.0f, yOff).anchor(SpriteAnchor.TOP_LEFT).alpha(alpha).end();
            if (stacks == maxStacks) {
                poseStack.translate(Math.sin((float)(player.tickCount + i) + partialTicks) * 2.0, 0.0, 0.0);
            }
            GUIRenderer.begin(TOOTH, poseStack).pos(0.0f, yOff).anchor(SpriteAnchor.TOP_LEFT).alpha(alpha).end();
            poseStack.popPose();
            yOff += height;
            ++i;
        }
        yOff = 0;
        i = 0;
        while ((double)i < Math.ceil((double)maxHeight / (double)height)) {
            poseStack.pushPose();
            poseStack.translate((float)width - (float)width * progress, 0.0f, 0.0f);
            GUIRenderer.begin(GUM, poseStack).pos(maxWidth - width, yOff).mirror(SpriteMirror.HORIZONTAL).anchor(SpriteAnchor.TOP_LEFT).alpha(alpha).end();
            if (stacks == maxStacks) {
                poseStack.translate(Math.sin((float)(player.tickCount + i) + partialTicks) * 2.0, 0.0, 0.0);
            }
            GUIRenderer.begin(TOOTH, poseStack).pos(maxWidth - width, yOff).mirror(SpriteMirror.HORIZONTAL).anchor(SpriteAnchor.TOP_LEFT).alpha(alpha).end();
            poseStack.popPose();
            yOff += height;
            ++i;
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

