/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.models.items;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class LeafyMantleModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"leafy_mantle"), "leafy_mantle");
    public ModelPart bodyPart;
    public ModelPart leftArmPart;
    public ModelPart rightArmPart;

    public LeafyMantleModel(ModelPart root) {
        super(root);
        this.bodyPart = root.getChild("body");
        this.leftArmPart = root.getChild("left_arm");
        this.rightArmPart = root.getChild("right_arm");
    }

    public static LayerDefinition constructLayerDefinition() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-3.0E-4f, (float)0.3556f, (float)0.0307f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(44, 24).addBox(-5.501f, 0.3112f, -2.8444f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)0.2131f, (float)0.3331f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(44, 49).addBox(-5.5f, -3.0f, 0.0f, 11.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)20.1503f, (float)9.4187f, (float)1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(44, 43).addBox(-5.5f, -3.0f, 0.0f, 11.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)16.9003f, (float)8.5187f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(44, 37).addBox(-5.5f, -3.0f, 0.0f, 11.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)12.9003f, (float)7.5687f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = body.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(44, 31).addBox(-5.5f, -3.0f, 0.0f, 11.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)9.4003f, (float)6.8687f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = body.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(22, 15).addBox(-5.5f, -1.0585f, 3.4436f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-5.5f, -0.5585f, 3.1936f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 39).addBox(-5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(32, 6).addBox(-5.5f, -0.5585f, -2.8064f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = body.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -2.2416f, 2.3602f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = body.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(32, 0).addBox(-5.501f, 20.9365f, 11.0185f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 39).addBox(-1.5f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.751f, (float)2.2082f, (float)0.0538f));
        PartDefinition right_arm = partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 12).addBox(-3.5f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.751f, (float)2.2082f, (float)0.0538f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.bodyPart, (Object)this.leftArmPart, (Object)this.rightArmPart);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of();
    }
}

