/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.ConstellationStarModel;
import it.hurts.sskirillss.relics.entities.relic.midnight_mantle.ConstellationStarEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ConstellationStarRenderer
extends EntityRenderer<ConstellationStarEntity> {
    public ConstellationStarRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(ConstellationStarEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        float time = (float)entity.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        poseStack.pushPose();
        float baseY = -0.85f;
        poseStack.translate(0.0f, baseY, 0.0f);
        float bob = (float)Math.sin((double)time * 0.1) * 0.05f;
        poseStack.translate(0.0f, bob, 0.0f);
        float jitterX = (float)Math.sin((double)time * 0.5) * 0.02f;
        float jitterZ = (float)Math.cos((double)time * 0.7) * 0.02f;
        poseStack.translate(jitterX, 0.0f, jitterZ);
        float rotation = time * 30.0f % 360.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        float scale = 1.0f + (float)Math.sin((double)time * 0.3) * 0.1f;
        poseStack.scale(scale, scale, scale);
        new ConstellationStarModel().renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(ConstellationStarEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/entities/constellation_star" + (entity.isFlawless() ? "_flawless" : "") + ".png"));
    }
}

