/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.GoldenToothModel;
import it.hurts.sskirillss.relics.entities.GoldenToothEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GoldenToothRenderer
extends EntityRenderer<GoldenToothEntity> {
    public GoldenToothRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(GoldenToothEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        float time = (float)entity.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        poseStack.pushPose();
        float bob = (float)Math.sin((double)time * 0.1) * 0.05f;
        poseStack.translate(0.0f, bob, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(0.0, (double)-1.15f, -0.025);
        float rotation = time * 20.0f % 360.0f;
        poseStack.translate(0.0, 0.0, 0.02);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.translate(0.0, 0.0, -0.02);
        float scale = 0.65f;
        poseStack.scale(scale, scale, scale);
        new GoldenToothModel().renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(GoldenToothEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/golden_tooth.png");
    }
}

