/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.LeafCoreModel;
import it.hurts.sskirillss.relics.entities.LeavesBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class LeavesBlockRenderer
extends EntityRenderer<LeavesBlockEntity> {
    public LeavesBlockRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(LeavesBlockEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        BlockState state = entity.getBlockState();
        if (state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = dispatcher.getBlockModel(state);
        BlockPos pos = new BlockPos((int)entity.getX(), (int)entity.getBoundingBox().maxY, (int)entity.getZ());
        float time = (float)entity.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.35f, 0.0f);
        poseStack.mulPose(Axis.YN.rotationDegrees(time * 20.0f));
        poseStack.mulPose(Axis.XN.rotationDegrees(time * 20.0f));
        poseStack.translate(0.0f, -1.35f, 0.0f);
        new LeafCoreModel().renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.65f, 0.65f, 0.65f);
        poseStack.translate(0.0f, 0.575f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(time * 20.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(time * 20.0f));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create(), ModelData.EMPTY)) {
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)entity.level(), model, state, pos, poseStack, buffer.getBuffer(renderType), false, entity.getRandom(), state.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(LeavesBlockEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/entities/leaf_core" + (entity.isFlawless() ? "_flawless" : "") + ".png"));
    }
}

