/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.entities.ShockwaveBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ShockwaveBlockRenderer
extends EntityRenderer<ShockwaveBlockEntity> {
    public ShockwaveBlockRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(ShockwaveBlockEntity entity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)entity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        BlockState state = entity.getBlockState();
        if (state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = dispatcher.getBlockModel(state);
        BlockPos pos = new BlockPos((int)entity.getX(), (int)entity.getBoundingBox().maxY, (int)entity.getZ());
        pMatrixStack.pushPose();
        pMatrixStack.translate(-0.5f, 0.0f, -0.5f);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create(), ModelData.EMPTY)) {
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)entity.level(), model, state, pos, pMatrixStack, pBuffer.getBuffer(renderType), false, RandomSource.create(), state.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
        }
        pMatrixStack.popPose();
    }

    public ResourceLocation getTextureLocation(ShockwaveBlockEntity pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

