/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.items.JellyfishNecklaceArcModel;
import it.hurts.sskirillss.relics.client.models.items.JellyfishNecklaceModel;
import it.hurts.sskirillss.relics.client.renderer.items.base.AbstractNecklaceRenderer;
import it.hurts.sskirillss.relics.items.relics.necklace.JellyfishNecklaceItem;
import it.hurts.sskirillss.relics.utils.FlawlessUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class JellyfishNecklaceRenderer
extends AbstractNecklaceRenderer<LivingEntity, JellyfishNecklaceModel> {
    public JellyfishNecklaceRenderer() {
        super(() -> new JellyfishNecklaceModel(Minecraft.getInstance().getEntityModels().bakeLayer(JellyfishNecklaceModel.LAYER)), ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/jellyfish_necklace.png"));
    }

    @Override
    public <E extends LivingEntity, EM extends EntityModel<E>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<E, EM> parent, MultiBufferSource bufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        super.render(stack, slotContext, poseStack, parent, bufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        Item item = stack.getItem();
        if (!(item instanceof JellyfishNecklaceItem)) {
            return;
        }
        JellyfishNecklaceItem relic = (JellyfishNecklaceItem)item;
        LivingEntity entity = slotContext.entity();
        float time = (float)entity.tickCount + partialTicks;
        int count = relic.getRings(stack);
        float spinSpeed = 15.0f;
        for (int i = 0; i < count; ++i) {
            double phase = Math.PI * 2 * (double)i / (double)count;
            poseStack.pushPose();
            ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)((double)(time * spinSpeed) + phase * 180.0 / Math.PI)));
            float shakeX = (float)Math.sin((double)(time * 1.5f) + phase) * 2.5f;
            float shakeZ = (float)Math.cos((double)(time * 2.0f) + phase) * 2.5f;
            poseStack.mulPose(Axis.XP.rotationDegrees(shakeX));
            poseStack.mulPose(Axis.ZP.rotationDegrees(shakeZ));
            float scale = 1.0f + (float)Math.sin((double)(time * 0.75f) + phase) * 0.075f;
            poseStack.scale(scale, scale, scale);
            new JellyfishNecklaceArcModel().renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)FlawlessUtils.getTexture(entity, stack, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/item/model/jellyfish_necklace_arc_" + ((int)(time % 4.0f) + 1) + ".png"))))), 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }

    @Override
    protected float getJellyIntensity() {
        return 0.5f;
    }

    @Override
    protected float getMovementSwingIntensity() {
        return 0.4f;
    }
}

