/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.items;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.models.items.KineticBeltModel;
import it.hurts.sskirillss.relics.client.models.items.KineticBeltWingsModel;
import it.hurts.sskirillss.relics.client.renderer.items.base.IRelicRenderer;
import it.hurts.sskirillss.relics.items.relics.belt.KineticBeltItem;
import it.hurts.sskirillss.relics.utils.FlawlessUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class KineticBeltRenderer
implements IRelicRenderer {
    private final KineticBeltModel model = new KineticBeltModel(Minecraft.getInstance().getEntityModels().bakeLayer(KineticBeltModel.LAYER));

    public <E extends LivingEntity, EM extends EntityModel<E>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<E, EM> parent, MultiBufferSource bufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        KineticBeltItem relic = (KineticBeltItem)stack.getItem();
        poseStack.pushPose();
        this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{this.model});
        if (relic.isRelicFlawless(entity, stack)) {
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/kinetic_belt_flawless.png"))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        } else {
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/kinetic_belt.png"))), light, OverlayTexture.NO_OVERLAY);
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/kinetic_belt_glow.png"))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        if (relic.isActive(stack)) {
            float time = (float)entity.tickCount + partialTicks;
            float shakeX = Mth.sin((float)(time * 3.0f)) * 0.01f;
            float shakeY = Mth.sin((float)(time * 2.0f)) * 0.025f;
            float shakeZ = Mth.cos((float)(time * 3.0f)) * 0.01f;
            poseStack.translate(shakeX, shakeY, shakeZ);
            new KineticBeltWingsModel().renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)FlawlessUtils.getTexture(entity, stack, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/kinetic_belt_wings.png")))), 0xF000F0, OverlayTexture.NO_OVERLAY, new Color(1.0f, 1.0f, 1.0f, 0.9f + Mth.sin((float)(time * 2.0f)) * 0.1f).getRGB());
        }
        poseStack.popPose();
    }
}

