/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.items.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.renderer.items.base.INecklaceModel;
import it.hurts.sskirillss.relics.client.renderer.items.base.IRelicRenderer;
import it.hurts.sskirillss.relics.utils.FlawlessUtils;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public abstract class AbstractNecklaceRenderer<T extends LivingEntity, M extends EntityModel<?>>
implements IRelicRenderer {
    private final M model;
    private final ResourceLocation texture;

    protected AbstractNecklaceRenderer(Supplier<M> modelSupplier, ResourceLocation texture) {
        this.model = (EntityModel)modelSupplier.get();
        this.texture = texture;
    }

    public <E extends LivingEntity, EM extends EntityModel<E>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<E, EM> parent, MultiBufferSource bufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        IRelicItem relic = (IRelicItem)stack.getItem();
        poseStack.pushPose();
        ((INecklaceModel)this.model).prepareMobModel(player, limbSwing, limbSwingAmount, partialTicks);
        ((INecklaceModel)this.model).setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)player, (HumanoidModel[])new HumanoidModel[]{(HumanoidModel)this.model});
        ((INecklaceModel)this.model).getBodyPart().translateAndRotate(poseStack);
        poseStack.translate(0.0f, 1.0f, 0.015f);
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)RenderType.entityTranslucentCull((ResourceLocation)FlawlessUtils.getTexture((LivingEntity)player, stack, this.texture)), (boolean)stack.hasFoil());
        ((INecklaceModel)this.model).getBodyPart().getChild("neck").render(poseStack, vertexConsumer, relic.isRelicFlawless((LivingEntity)player, stack) ? 0xF000F0 : light, OverlayTexture.NO_OVERLAY);
        double deltaX = Mth.lerp((double)partialTicks, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX());
        double deltaY = Mth.lerp((double)partialTicks, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY());
        double deltaZ = Mth.lerp((double)partialTicks, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ());
        double verticalMotion = Mth.clamp((double)(deltaY * 10.0), (double)-6.0, (double)32.0);
        float bodyYaw = Mth.rotLerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        float sin = (float)Math.sin(bodyYaw);
        float cos = (float)(-Math.cos(bodyYaw));
        double forwardMotion = Mth.clamp((double)((deltaX * (double)sin + deltaZ * (double)cos) * 100.0), (double)-80.0, (double)80.0);
        double sideMotion = Mth.clamp((double)((deltaX * (double)cos - deltaZ * (double)sin) * 100.0), (double)-20.0, (double)20.0);
        double pressTilt = forwardMotion > 0.0 ? forwardMotion * (double)0.1f : forwardMotion * (double)0.3f;
        double liftTilt = verticalMotion > 0.0 ? -verticalMotion * 2.0 : -verticalMotion * (double)0.05f;
        double rawX = pressTilt + liftTilt;
        double rawY = sideMotion * (double)0.7f;
        float nlX = (float)Math.signum(rawX) * (float)Math.pow(Math.abs(rawX), 1.2f);
        float nlY = (float)Math.signum(rawY) * (float)Math.pow(Math.abs(rawY), 1.2f);
        float rotX = nlX * ((float)Math.PI / 180);
        float rotY = nlY * ((float)Math.PI / 180);
        ModelPart pendant = ((INecklaceModel)this.model).getBodyPart().getChild("pendant");
        poseStack.pushPose();
        float px = pendant.x / 16.0f;
        float py = pendant.y / 16.0f;
        float pz = pendant.z / 16.0f;
        poseStack.translate(px, py, pz);
        double rawJ = Mth.clamp((double)(verticalMotion * (double)0.035f), (double)-0.3f, (double)0.3f);
        float jelly = (float)(-rawJ * (double)this.getJellyIntensity());
        poseStack.scale(1.0f - jelly * (jelly < 0.0f ? 3.0f : 1.0f), 1.0f + jelly * 3.0f, 1.0f - jelly * (jelly < 0.0f ? 3.0f : 1.0f));
        poseStack.translate(-px, -py, -pz);
        float mi = this.getMovementSwingIntensity();
        pendant.xRot = rotX * mi;
        pendant.yRot = rotY * mi;
        pendant.zRot = 0.0f;
        float t = ageInTicks + partialTicks;
        float idleI = this.getIdleSwingIntensity();
        pendant.xRot += (Mth.sin((float)(t * 0.1f)) + Mth.sin((float)(t * 0.3f))) * idleI;
        pendant.yRot += (Mth.cos((float)(t * 0.1f)) + Mth.cos((float)(t * 0.3f))) * idleI;
        float atk = player.getAttackAnim(partialTicks);
        if (atk > 0.0f) {
            pendant.yRot -= Mth.sin((float)(atk * (float)Math.PI)) * 0.35f;
        }
        pendant.render(poseStack, vertexConsumer, relic.isRelicFlawless((LivingEntity)player, stack) ? 0xF000F0 : light, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        poseStack.popPose();
    }

    protected float getJellyIntensity() {
        return 0.0f;
    }

    protected float getMovementSwingIntensity() {
        return 0.9f;
    }

    protected float getIdleSwingIntensity() {
        return 0.05f;
    }
}

