/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategory;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategory;
import it.hurts.sskirillss.relics.badges.base.AbilityBadge;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IPagedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.base.ITabbedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.AbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.AbilityModeWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.AbilityPageWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.BigAbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.RerollAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.ResetAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.UpgradeAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.AbilityBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.ScrollbarWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.DescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.init.RelicsBadges;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends DescriptionScreen
implements ITabbedDescriptionScreen,
IPagedDescriptionScreen {
    private int pageOld;
    private String selectedAbility;
    private DescriptionSubcategory subcategory = DescriptionSubcategories.getSubcategory("ability_description");
    private UpgradeAbilityActionWidget upgradeButton;
    private RerollAbilityActionWidget rerollButton;
    private ResetAbilityActionWidget resetButton;

    public AbilityDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super(player, container, slot, screen);
        Item item = this.stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            List<String> abilities = relic.getAbilitiesTemplate((LivingEntity)player, this.stack).getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled((LivingEntity)player, this.stack, (String)entry)).toList();
            if (this.selectedAbility == null) {
                this.setSelectedAbility(abilities.getFirst());
            }
            this.setPageOld(abilities.indexOf(this.getSelectedAbility()) / 5);
        }
    }

    @Override
    protected void init() {
        Item item;
        super.init();
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        LocalPlayer player = this.minecraft.player;
        String ability = this.getSelectedAbility();
        if (relic.getAbilityTemplate((LivingEntity)player, this.stack, ability) == null) {
            return;
        }
        List<String> abilities = relic.getAbilitiesTemplate((LivingEntity)player, this.stack).getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled((LivingEntity)player, this.stack, (String)entry)).toList();
        int maxEntries = 4;
        if (abilities.size() > maxEntries) {
            this.addRenderableWidget((GuiEventListener)new AbilityPageWidget(this.x + 289, this.y + 151, this, -1));
            this.addRenderableWidget((GuiEventListener)new AbilityPageWidget(this.x + 289, this.y + 186, this, 1));
        }
        int startIndex = this.pageOld * maxEntries;
        int endIndex = Math.min(startIndex + maxEntries, abilities.size());
        ArrayList paginatedAbilities = startIndex < abilities.size() && startIndex >= 0 ? abilities.subList(startIndex, endIndex) : new ArrayList();
        int xOff = 0;
        this.addRenderableWidget((GuiEventListener)new BigAbilityCardWidget(this.x + 59, this.y + 43, this));
        if (relic.isAbilityUnlocked((LivingEntity)player, this.stack, ability)) {
            for (AbilityBadge badge : RelicsBadges.BADGES.getEntries().stream().map(DeferredHolder::get).filter(entry -> entry instanceof AbilityBadge).map(entry -> (AbilityBadge)entry).toList()) {
                if (!badge.isVisible((LivingEntity)player, this.stack, ability)) continue;
                this.addRenderableWidget((GuiEventListener)new AbilityBadgeWidget(this.x + 260 - xOff, this.y + 54, this, badge, ability));
                xOff += 15;
            }
        }
        if (!paginatedAbilities.isEmpty()) {
            int objectWidth = 38;
            int containerWidth = 209;
            int count = paginatedAbilities.size();
            int spacing = objectWidth + 8 + 3 * (maxEntries - count);
            xOff = containerWidth / 2 - (objectWidth * count + (spacing - objectWidth) * Math.max(count - 1, 0)) / 2;
            for (String entry2 : paginatedAbilities) {
                this.addRenderableWidget((GuiEventListener)new AbilityCardWidget(this.x + 77 + xOff, this.y + 160, this, entry2));
                xOff += spacing;
            }
        }
        this.initActionButtons();
        DescriptionContainerWidget container = this.subcategory.getContainerWidget(this);
        this.addRenderableWidget((GuiEventListener)container);
        this.addRenderableWidget((GuiEventListener)new ScrollbarWidget(this.x + 279, this.y + 74, container));
        this.initModeButtons();
    }

    public void initActionButtons() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        String ability = this.getSelectedAbility();
        LocalPlayer player = this.minecraft.player;
        if (relic.isAbilityUpgradeEnabled((LivingEntity)player, this.stack, ability)) {
            this.upgradeButton = (UpgradeAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new UpgradeAbilityActionWidget(this.x + 289, this.y + 63, this));
        }
        if (relic.isAbilityRerollEnabled((LivingEntity)player, this.stack, ability)) {
            this.rerollButton = (RerollAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new RerollAbilityActionWidget(this.x + 289, this.y + 84, this));
        }
        if (relic.isAbilityResetEnabled((LivingEntity)player, this.stack, ability)) {
            this.resetButton = (ResetAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new ResetAbilityActionWidget(this.x + 289, this.y + 105, this));
        }
    }

    public void initModeButtons() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        String ability = this.getSelectedAbility();
        LocalPlayer player = this.minecraft.player;
        if (relic.isAbilityUnlocked((LivingEntity)player, this.stack, ability) && !relic.getAbilityTemplate((LivingEntity)player, this.stack, this.getSelectedAbility()).getModes().isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new AbilityModeWidget(this.x + 100, this.y + 53, this, 1));
            this.addRenderableWidget((GuiEventListener)new AbilityModeWidget(this.x + 56, this.y + 53, this, -1));
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        block7: {
            block6: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = Minecraft.getInstance().player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block6;
                relic = (IRelicItem)item;
                if (player != null) break block7;
            }
            return;
        }
        String ability = this.getSelectedAbility();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 1.0f);
        MutableComponent title = Component.translatableWithFallback((String)("relics.description." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + ability), (String)ability);
        List<String> modes = relic.getAbilityTemplate((LivingEntity)player, this.stack, ability).getModes();
        if (!modes.isEmpty()) {
            title.append((Component)Component.literal((String)" [").append((Component)Component.translatable((String)("relics.description." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + ability + ".mode." + relic.getAbilityMode((LivingEntity)player, this.stack, ability)))).append((Component)Component.literal((String)"]")));
        }
        if (!relic.isAbilityUnlocked((LivingEntity)player, this.stack, ability)) {
            title = ScreenUtils.stylizeWithReplacement(title, 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(10354864), (long)ability.length());
            RandomSource random = player.getRandom();
            float shakeX = MathUtils.randomFloat(random) * 0.5f;
            float shakeY = MathUtils.randomFloat(random) * 0.5f;
            poseStack.translate(shakeX, shakeY, 0.0f);
        } else {
            title.withStyle(ChatFormatting.BOLD);
        }
        guiGraphics.drawString(this.minecraft.font, (Component)title.withStyle(ChatFormatting.BOLD), (int)((float)(this.x + 114) * 1.33f), (int)((float)(this.y + 62) * 1.33f), 7548704, false);
        poseStack.popPose();
        poseStack.pushPose();
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/top_background_delimiter.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.x + 107, this.y + 70).end();
        poseStack.popPose();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (Minecraft.getInstance().options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.screen.rebuildWidgets();
        Minecraft.getInstance().setScreen(this.screen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public DescriptionCategory getCategory() {
        return DescriptionCategories.getCategory("ability");
    }

    @Generated
    public int getPageOld() {
        return this.pageOld;
    }

    @Generated
    public void setPageOld(int pageOld) {
        this.pageOld = pageOld;
    }

    @Generated
    public String getSelectedAbility() {
        return this.selectedAbility;
    }

    @Generated
    public void setSelectedAbility(String selectedAbility) {
        this.selectedAbility = selectedAbility;
    }

    @Override
    @Generated
    public DescriptionSubcategory getSubcategory() {
        return this.subcategory;
    }

    @Override
    @Generated
    public void setSubcategory(DescriptionSubcategory subcategory) {
        this.subcategory = subcategory;
    }

    @Generated
    public UpgradeAbilityActionWidget getUpgradeButton() {
        return this.upgradeButton;
    }

    @Generated
    public RerollAbilityActionWidget getRerollButton() {
        return this.rerollButton;
    }

    @Generated
    public ResetAbilityActionWidget getResetButton() {
        return this.resetButton;
    }
}

