/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.SimpleDescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AbilityExperienceContainerWidget
extends SimpleDescriptionContainerWidget {
    public AbilityExperienceContainerWidget(DescriptionScreen screen) {
        super(screen);
    }

    @Override
    public List<FormattedCharSequence> getContent() {
        DescriptionScreen descriptionScreen = this.getScreen();
        if (!(descriptionScreen instanceof AbilityDescriptionScreen)) {
            return new ArrayList<FormattedCharSequence>();
        }
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)descriptionScreen;
        ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        LocalPlayer player = this.minecraft.player;
        Font font = this.minecraft.font;
        int maxWidth = 320;
        String ability = screen.getSelectedAbility();
        LinkedHashMap<String, List> group = new LinkedHashMap<String, List>();
        HashMap<String, MutableComponent> conditions = new HashMap<String, MutableComponent>();
        for (ExperienceSourceTemplate source : relic.getExperienceSourcesTemplate((LivingEntity)player, stack, ability).getSources().values()) {
            VisibilityState state = source.getVisibilityState().apply((LivingEntity)player, stack, ability, source.getId());
            if (state == VisibilityState.HIDDEN) continue;
            MutableComponent condition = source.getConditionComponent().apply((LivingEntity)player, stack, ability, source.getId()).withStyle(ChatFormatting.BOLD);
            String key = condition.getString().trim();
            MutableComponent description = Component.literal((String)"\u25cf ").append((Component)source.getDescriptionComponent().apply((LivingEntity)player, stack, ability, source.getId()));
            if (state == VisibilityState.OBFUSCATED) {
                description = ScreenUtils.randomizeAllCharacters(description, this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
            }
            group.computeIfAbsent(key, k -> new ArrayList()).add(description);
            if (key.isBlank() || conditions.containsKey(key)) continue;
            conditions.put(key, condition);
        }
        boolean firstGroup = true;
        for (Map.Entry entry : group.entrySet()) {
            if (!firstGroup) {
                sequences.addAll(font.split((FormattedText)Component.literal((String)" "), maxWidth));
            }
            firstGroup = false;
            String key = (String)entry.getKey();
            if (!key.isBlank() && conditions.containsKey(key) && !((MutableComponent)conditions.get(key)).equals((Object)Component.empty())) {
                sequences.addAll(font.split((FormattedText)conditions.get(key), maxWidth));
            }
            for (MutableComponent desc : (List)entry.getValue()) {
                sequences.addAll(font.split((FormattedText)desc, maxWidth));
            }
        }
        return sequences;
    }
}

