/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base.AbstractAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.RelicsHotkeys;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketAbilityTweak;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeAbilityActionWidget
extends AbstractAbilityActionWidget {
    public UpgradeAbilityActionWidget(int x, int y, AbilityDescriptionScreen screen) {
        super(x, y, PacketAbilityTweak.Operation.UPGRADE, screen);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getScreen().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerUpgrade((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        Item item = this.getScreen().getStack().getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            if (!this.isLocked()) {
                int level = relic.getAbilityLevel((LivingEntity)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
                int maxLevel = relic.getAbilityTemplate((LivingEntity)this.minecraft.player, this.getScreen().getStack(), this.getAbility()).getInitialMaxLevel();
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.TABLE_UPGRADE.get()), (float)(Screen.hasShiftDown() && relic.mayPlayerUpgrade((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility()) ? 2.0f : 1.0f + (float)level / (float)maxLevel)));
            }
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.getScreen().getStack().getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        boolean isQuick = Screen.hasShiftDown() && relic.mayPlayerUpgrade((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
        float color = isQuick ? (float)((double)1.05f + Math.sin((float)(this.minecraft.player.tickCount + this.getAbility().length() * 10) * 0.5f) * (double)0.1f) : 1.0f;
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/ability/upgrade_button_" + (this.isLocked() ? "inactive" : "active") + (isQuick ? "_quick" : "") + ".png")), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.ACTION_BUTTON_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
    }

    @Override
    public List<MutableComponent> buildDescription() {
        List<MutableComponent> description = super.buildDescription();
        AbilityDescriptionScreen screen = this.getScreen();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        String ability = screen.getSelectedAbility();
        int key = RelicsHotkeys.RESEARCH_RELIC.getKey().getValue();
        boolean hasShiftDown = key != -1 && InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)key);
        MutableComponent newLine = Component.literal((String)" ");
        long currentExperience = EntityUtils.getPlayerTotalExperience((Player)player);
        int requiredExperience = relic.getUpgradePlayerExperienceCost((LivingEntity)player, stack, this.getAbility());
        boolean hasExperience = (long)requiredExperience <= currentExperience;
        int currentLevelingPoints = relic.getRelicLevelingPoints((LivingEntity)player, stack);
        int requiredLevelingPoints = relic.getRelicTemplate((LivingEntity)player, stack).getAbilities().getAbilities().get(ability).getRequiredPoints();
        boolean hasLevelingPoints = requiredLevelingPoints <= currentLevelingPoints;
        int level = relic.getAbilityLevel((LivingEntity)player, stack, ability);
        int maxLevel = relic.getRelicTemplate((LivingEntity)player, stack).getAbilities().getAbilities().get(ability).getInitialMaxLevel();
        boolean isMaxLevel = level >= maxLevel;
        description.add(Component.translatable((String)"relics.description.ability.levelup.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
        description.add(newLine);
        if (isMaxLevel) {
            description.add(Component.translatable((String)"relics.description.ability.levelup.max_level").withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
        } else {
            description.add(Component.translatable((String)"relics.description.general.cost.title").withStyle(ChatFormatting.BOLD).append((Component)Component.literal((String)" ")));
            double relativeLevelCost = hasExperience ? EntityUtils.calculateExperienceLevelLoss((Player)player, requiredExperience) : EntityUtils.getLevelFromTotalExperience(requiredExperience);
            description.add(Component.literal((String)"   \u25cf ").append((Component)Component.translatable((String)"relics.description.ability.levelup.cost.entry_1", (Object[])new Object[]{hasShiftDown ? requiredExperience + "+" : Integer.valueOf(requiredExperience), hasShiftDown ? relativeLevelCost + "+" : Double.valueOf(relativeLevelCost)}).withColor(hasExperience ? DescriptionUtils.POSITIVE_COLOR(true) : DescriptionUtils.NEGATIVE_COLOR(true))));
            description.add(Component.literal((String)"   \u25cf ").append((Component)Component.translatable((String)"relics.description.ability.levelup.cost.entry_2", (Object[])new Object[]{hasShiftDown ? requiredLevelingPoints + "+" : Integer.valueOf(requiredLevelingPoints)}).withColor(hasLevelingPoints ? DescriptionUtils.POSITIVE_COLOR(true) : DescriptionUtils.NEGATIVE_COLOR(true))));
            description.add(newLine);
            description.add(Component.translatable((String)"relics.description.ability.levelup.auto", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName().getString()}).withColor(DescriptionUtils.NEUTRAL_COLOR(true)));
        }
        description.add(newLine);
        if (hasShiftDown) {
            description.add(Component.translatable((String)"relics.description.ability.levelup.description").withStyle(ChatFormatting.ITALIC));
        } else {
            description.add(Component.translatable((String)"relics.general.hold_shift", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName().getString()}));
        }
        return description;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList tooltip = new ArrayList();
        PoseStack poseStack = guiGraphics.pose();
        int maxWidth = 150;
        int renderWidth = 0;
        for (MutableComponent entry : this.buildDescription()) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

