/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.base;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategory;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategory;
import it.hurts.sskirillss.relics.client.screen.description.base.SimpleDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LevelingPointsPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LogoWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PlayerExperiencePlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsFixWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.RankPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.RelicProgressPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.PageWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.RelicExperienceWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.TabWidget;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DescriptionScreen
extends SimpleDescriptionScreen {
    public final int backgroundHeight = 256;
    public final int backgroundWidth = 418;
    public int x;
    public int y;

    protected DescriptionScreen(Player player, int container, int slot, Screen screen) {
        super(player, container, slot, screen);
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.backgroundWidth) / 2;
        this.y = (this.height - this.backgroundHeight) / 2;
        this.initSidebar();
        this.initTopScroll();
        this.initBottomScroll();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSpaceBackground(guiGraphics);
        this.renderTopScroll(guiGraphics);
        this.renderBottomScroll(guiGraphics);
    }

    protected void initSidebar() {
        if (LogoWidget.getRemainingClicks() != 0) {
            this.addRenderableWidget((GuiEventListener)new LogoWidget(this.x + 313, this.y + 53, this));
        }
        if (((IRelicItem)this.stack.getItem()).isSomethingWrongWithLevelingPoints((LivingEntity)this.minecraft.player, this.stack)) {
            this.addRenderableWidget((GuiEventListener)new PointsFixWidget(this.x + 330, this.y + 33, this));
        }
        this.addRenderableWidget((GuiEventListener)new RelicProgressPlateWidget(this.x + 313, this.y + 77, this));
        this.addRenderableWidget((GuiEventListener)new RankPlateWidget(this.x + 313, this.y + 102, this));
        this.addRenderableWidget((GuiEventListener)new LevelingPointsPlateWidget(this.x + 313, this.y + 127, this));
        this.addRenderableWidget((GuiEventListener)new PlayerExperiencePlateWidget(this.x + 313, this.y + 152, this));
    }

    protected void initTopScroll() {
        LocalPlayer player = this.minecraft.player;
        int xOff = 0;
        List subcategories = DescriptionSubcategories.getSubcategories().values().stream().filter(subcategory -> subcategory.shouldAppear(this, (LivingEntity)player, this.stack)).sorted(Comparator.comparingInt(subcategory -> subcategory.getOrder((LivingEntity)player, this.stack))).collect(Collectors.toList());
        if (subcategories.size() > 1) {
            Collections.reverse(subcategories);
            for (DescriptionSubcategory subcategory2 : subcategories) {
                this.addRenderableWidget((GuiEventListener)new PageWidget(this.x + 261 + xOff, this.y + 35, this, subcategory2));
                xOff -= 19;
            }
        }
        this.addRenderableWidget((GuiEventListener)new RelicExperienceWidget(this.x + 142, this.y + 133, this));
    }

    protected void initBottomScroll() {
        LocalPlayer player = this.minecraft.player;
        int xOff = 0;
        for (DescriptionCategory category2 : DescriptionCategories.getCategories().values().stream().filter(category -> category.shouldAppear((LivingEntity)player, this.stack)).sorted(Comparator.comparingInt(category -> category.getOrder((LivingEntity)player, this.stack))).toList()) {
            this.addRenderableWidget((GuiEventListener)new TabWidget(this.x + 81 + xOff, this.y + 134, this, category2));
            xOff += 19;
        }
    }

    protected void renderSpaceBackground(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        GUIRenderer.begin(DescriptionTextures.SPACE_BACKGROUND, poseStack).texSize(418, 4096).patternSize(418, 256).pos((float)this.x + 209.0f, (float)this.y + 128.0f).animation(AnimationData.construct(4096, 256, 2)).end();
    }

    protected void renderTopScroll(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        GUIRenderer.begin(DescriptionTextures.TOP_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.x + 105, this.y + 45).end();
    }

    protected void renderBottomScroll(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        GUIRenderer.begin(DescriptionTextures.BOTTOM_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.x + 59, this.y + 144).end();
    }
}

