/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.base;

import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleDescriptionScreen
extends Screen
implements IAutoScaledScreen {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;

    protected SimpleDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super((Component)Component.empty());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    public void tick() {
        super.tick();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.stack = DescriptionUtils.gatherRelicStack((Player)player, this.slot);
            Screen screen = this.screen;
            if (screen instanceof DescriptionScreen) {
                DescriptionScreen subScreen = (DescriptionScreen)screen;
                subScreen.stack = DescriptionUtils.gatherRelicStack((Player)player, this.slot);
            }
        }
    }

    @Override
    public int getAutoScale() {
        return 4;
    }

    @Generated
    public int getContainer() {
        return this.container;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }
}

