/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerExperiencePlateWidget
extends AbstractPlateWidget {
    public PlayerExperiencePlateWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, screen, "player_experience");
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int barWidth = 52;
        int barHeight = 2;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        GUIRenderer.begin(DescriptionTextures.PLATE_PLAYER_EXPERIENCE_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(1.0f, this.height - 3).end();
        GUIRenderer.begin(DescriptionTextures.PLATE_PLAYER_EXPERIENCE_FILLER, poseStack).pos(1.0f, this.height - 3).texSize(barWidth, barHeight).anchor(SpriteAnchor.TOP_LEFT).patternSize((int)((float)barWidth * this.minecraft.player.experienceProgress), barHeight).end();
        poseStack.popPose();
    }

    @Override
    public List<MutableComponent> getHoverTooltip() {
        long experience = EntityUtils.getPlayerTotalExperience((Player)this.minecraft.player);
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>();
        entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.general.player_experience.title_1").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" ").append((Component)Component.translatable((String)"relics.description.researching.general.player_experience.title_2", (Object[])new Object[]{experience, EntityUtils.getLevelFromTotalExperience(experience)})));
        entries.add(Component.literal((String)" "));
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"relics.description.researching.general.player_experience.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
        }
        return entries;
    }

    @Override
    public String getValue(ItemStack stack) {
        return String.valueOf(this.minecraft.player.experienceLevel);
    }
}

