/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.FixLevelingPoints;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@Deprecated(forRemoval=true)
public class PointsFixWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private DescriptionScreen screen;

    public PointsFixWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, 18, 18);
        this.screen = screen;
    }

    @Override
    public void onPress() {
        IRelicItem relic;
        Item item = this.screen.getStack().getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isSomethingWrongWithLevelingPoints((LivingEntity)this.minecraft.player, this.screen.getStack())) {
            return;
        }
        NetworkHandler.sendToServer(new FixLevelingPoints(this.screen.getContainer(), this.screen.getSlot()));
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.getStack().getItem()) instanceof IRelicItem) || !(relic = (IRelicItem)item).isSomethingWrongWithLevelingPoints((LivingEntity)player, this.screen.getStack())) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float color = (float)(1.25 + Math.sin(player.tickCount) * 0.5);
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/fix.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).color(color, color, color, 1.0f).pos(this.getX(), this.getY()).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        ItemStack stack = this.getScreen().getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isSomethingWrongWithLevelingPoints((LivingEntity)this.minecraft.player, this.screen.getStack())) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"Looks like you have an incorrect number of leveling points. This may be a compatibility issue with previous releases of Relics. If you're sure something is wrong, click this button to fix it! This action cannot be undone!")});
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Generated
    public DescriptionScreen getScreen() {
        return this.screen;
    }
}

