/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractPlateWidget;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RankPlateWidget
extends AbstractPlateWidget {
    public RankPlateWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, screen, "rank");
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        PoseStack poseStack = guiGraphics.pose();
        float time = (float)player.tickCount + pPartialTick;
        if (!relic.isRelicMaxRank((LivingEntity)player, stack)) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(10.5f, 10.0f, -1.0f);
        poseStack.scale(16.0f, 16.0f, 16.0f);
        int beams = 8;
        for (int i = 0; i < beams; ++i) {
            float angle = (float)((double)((float)i * 2.0f) * Math.PI / (double)beams);
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotation(angle));
            poseStack.mulPose(Axis.ZP.rotation(time * 0.025f));
            double length = (double)0.85f + (i % 2 == 0 ? Math.sin(time * 0.25f) : Math.cos(time * 0.25f)) * (double)0.1f;
            RenderUtils.renderFlatBeam(guiGraphics, pPartialTick, (float)length, 0.45f, -16711681, 255);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    @Override
    public List<MutableComponent> getHoverTooltip() {
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>();
        ItemStack stack = this.getScreen().getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return entries;
        }
        IRelicItem relic = (IRelicItem)item;
        entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.general.relic_rank.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + relic.getRelicRank((LivingEntity)this.minecraft.player, stack)));
        entries.add(Component.literal((String)" "));
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"relics.description.researching.general.relic_rank.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
        }
        return entries;
    }

    @Override
    public String getValue(ItemStack stack) {
        int n;
        Item item = stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            n = relic.getRelicRank((LivingEntity)this.minecraft.player, stack);
        } else {
            n = 0;
        }
        return String.valueOf(n);
    }
}

