/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.badges.base.RelicBadge;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RelicBadgeWidget
extends AbstractBadgeWidget {
    private final RelicBadge badge;

    public RelicBadgeWidget(int x, int y, DescriptionScreen provider, RelicBadge badge) {
        super(x, y, provider, badge);
        this.badge = badge;
    }

    @Override
    public RelicBadge getBadge() {
        return this.badge;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.getScreen().getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{this.getBadge().getTitle((LivingEntity)this.minecraft.player, stack).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE), Component.literal((String)" ")});
        entries.addAll(this.getBadge().getDescription((LivingEntity)this.minecraft.player, stack));
        List<MutableComponent> hint = this.getBadge().getHint((LivingEntity)this.minecraft.player, stack);
        if (!hint.isEmpty()) {
            entries.add(Component.literal((String)" "));
            if (Screen.hasShiftDown()) {
                entries.addAll(hint.stream().map(entry -> entry.withStyle(ChatFormatting.ITALIC)).toList());
            } else {
                entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
            }
        }
        for (MutableComponent entry2 : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry2) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry2, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry3 : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry3, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }
}

