/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TextJustificator {
    private static final Pattern SPACE_RE = Pattern.compile("\\s+");
    private static final Pattern PLACEHOLDER_RE = Pattern.compile("([()%]*%(\\d+)\\$s[()%]*)");

    public static List<FormattedCharSequence> justifyStyledText(Component text, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        StringSplitter splitter = font.getSplitter();
        ArrayList<Token> tokens = new ArrayList<Token>();
        text.visit((style, str) -> {
            Matcher m = SPACE_RE.matcher(str);
            int last = 0;
            while (m.find()) {
                if (m.start() > last) {
                    tokens.add(new Token(str.substring(last, m.start()), style, false));
                }
                tokens.add(new Token(m.group(), style, true));
                last = m.end();
            }
            if (last < str.length()) {
                tokens.add(new Token(str.substring(last), style, false));
            }
            return Optional.empty();
        }, Style.EMPTY);
        ArrayList<FormattedCharSequence> result = new ArrayList<FormattedCharSequence>();
        ArrayList<Token> line = new ArrayList<Token>();
        float lineWidth = 0.0f;
        int i = 0;
        while (i < tokens.size()) {
            Token tok = (Token)tokens.get(i);
            float tokW = splitter.stringWidth(tok.asFT());
            if (!tok.isSpace && tokW > (float)maxWidth) {
                int cut = TextJustificator.fitPrefixByWidth(splitter, tok.raw, tok.style, (float)maxWidth - (line.isEmpty() ? 0.0f : lineWidth));
                if (cut == 0) {
                    cut = TextJustificator.firstCodePointEnd(tok.raw, 0);
                }
                String left = tok.raw.substring(0, cut);
                String right = tok.raw.substring(cut);
                Token leftTok = new Token(left, tok.style, false);
                float leftW = splitter.stringWidth(leftTok.asFT());
                if (lineWidth + leftW > (float)maxWidth && !line.isEmpty()) {
                    TextJustificator.emitLine(result, line, maxWidth, splitter, font, true);
                    line.clear();
                    lineWidth = 0.0f;
                    continue;
                }
                line.add(leftTok);
                lineWidth += leftW;
                tokens.set(i, new Token(right, tok.style, false));
                continue;
            }
            if (lineWidth + tokW > (float)maxWidth && !line.isEmpty()) {
                TextJustificator.emitLine(result, line, maxWidth, splitter, font, true);
                line.clear();
                lineWidth = 0.0f;
                continue;
            }
            if (tok.isSpace && line.isEmpty()) {
                tok = new Token(" ", tok.style, true);
                tokW = splitter.stringWidth(tok.asFT());
                tokens.set(i, tok);
            }
            line.add(tok);
            lineWidth += tokW;
            ++i;
        }
        if (!line.isEmpty()) {
            TextJustificator.emitLine(result, line, maxWidth, splitter, font, false);
        }
        return result;
    }

    private static void emitLine(List<FormattedCharSequence> out, List<Token> line, int maxWidth, StringSplitter splitter, Font font, boolean justify) {
        if (!justify) {
            out.add(Language.getInstance().getVisualOrder(FormattedText.composite(line.stream().map(Token::asFT).toList())));
            return;
        }
        int spaceTokens = 0;
        float width = 0.0f;
        for (Token t : line) {
            width += splitter.stringWidth(t.asFT());
            if (!t.isSpace) continue;
            ++spaceTokens;
        }
        if (spaceTokens == 0) {
            out.add(Language.getInstance().getVisualOrder(FormattedText.composite(line.stream().map(Token::asFT).toList())));
            return;
        }
        float missing = (float)maxWidth - width;
        if (missing <= 0.0f) {
            out.add(Language.getInstance().getVisualOrder(FormattedText.composite(line.stream().map(Token::asFT).toList())));
            return;
        }
        int spaceW = font.width(" ");
        int extraSpacesTotal = (int)Math.floor(missing / (float)spaceW);
        if (extraSpacesTotal <= 0) {
            out.add(Language.getInstance().getVisualOrder(FormattedText.composite(line.stream().map(Token::asFT).toList())));
            return;
        }
        int base = extraSpacesTotal / spaceTokens;
        int rem = extraSpacesTotal % spaceTokens;
        ArrayList<FormattedText> parts = new ArrayList<FormattedText>(line.size() * 2);
        int seenSpaces = 0;
        for (Token t : line) {
            if (!t.isSpace) {
                parts.add(t.asFT());
                continue;
            }
            int add = base + (seenSpaces < rem ? 1 : 0);
            ++seenSpaces;
            String s = t.raw + " ".repeat(add);
            parts.add(FormattedText.of((String)s, (Style)t.style));
        }
        out.add(Language.getInstance().getVisualOrder(FormattedText.composite(parts)));
    }

    public static List<LayoutLine> layoutJustifiedLines(Font font, List<LineEntry> rawLineEntries, List<MutableComponent> dynamicComponents, int maximumLineWidth) {
        StringSplitter splitter = font.getSplitter();
        int spaceWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)" ", (Style)Style.EMPTY)));
        ArrayList<LayoutLine> result = new ArrayList<LayoutLine>();
        for (LineEntry entry : rawLineEntries) {
            String rawText = entry.getRawLine().getString();
            if (rawText.isEmpty()) {
                result.add(new LayoutLine(List.of(), false));
                continue;
            }
            ArrayList<Word> words = new ArrayList<Word>();
            Matcher matcher = PLACEHOLDER_RE.matcher(rawText);
            Style baseStyle = entry.getRawLine().getStyle();
            int lastEnd = 0;
            while (matcher.find()) {
                if (matcher.start() > lastEnd) {
                    String before = rawText.substring(lastEnd, matcher.start());
                    TextJustificator.tokenizeLiteral(before, baseStyle, words);
                }
                String segment = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2)) - 1;
                MutableComponent dyn = dynamicComponents.get(index).copy();
                Style style = dyn.getStyle();
                String pre = segment.substring(0, segment.indexOf(37));
                String suf = segment.substring(segment.lastIndexOf(115) + 1);
                if (!pre.isEmpty()) {
                    dyn = Component.literal((String)pre).withStyle(style).append((Component)dyn);
                }
                if (!suf.isEmpty()) {
                    dyn = dyn.append((Component)Component.literal((String)suf).withStyle(style));
                }
                words.add(new Word(dyn, true));
                lastEnd = matcher.end();
            }
            if (lastEnd < rawText.length()) {
                String after = rawText.substring(lastEnd);
                TextJustificator.tokenizeLiteral(after, baseStyle, words);
            }
            ArrayList<ArrayList<Word>> lines = new ArrayList<ArrayList<Word>>();
            ArrayList<Word> current = new ArrayList<Word>();
            int used = 0;
            int i = 0;
            while (i < words.size()) {
                Word w = words.get(i);
                String wStr = w.component.getString();
                int wWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)wStr, (Style)w.component.getStyle()))) + (w.isDynamic ? 4 : 0);
                if (!w.isSpace() && wWidth > maximumLineWidth) {
                    int cut = TextJustificator.fitPrefixByWidth(splitter, wStr, w.component.getStyle(), maximumLineWidth - (current.isEmpty() ? 0 : used));
                    if (cut == 0) {
                        cut = TextJustificator.firstCodePointEnd(wStr, 0);
                    }
                    MutableComponent left = Component.literal((String)wStr.substring(0, cut)).withStyle(w.component.getStyle());
                    MutableComponent right = Component.literal((String)wStr.substring(cut)).withStyle(w.component.getStyle());
                    Word leftWord = new Word(left.copy(), false);
                    int leftWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)leftWord.component.getString(), (Style)leftWord.component.getStyle())));
                    if (!current.isEmpty() && used + leftWidth > maximumLineWidth) {
                        TextJustificator.dropTrailingSpaces(current);
                        lines.add(current);
                        current = new ArrayList();
                        used = 0;
                        continue;
                    }
                    current.add(leftWord);
                    used += leftWidth;
                    words.set(i, new Word(right.copy(), false));
                    continue;
                }
                if (!current.isEmpty() && used + wWidth > maximumLineWidth) {
                    TextJustificator.dropTrailingSpaces(current);
                    lines.add(current);
                    current = new ArrayList();
                    used = 0;
                    continue;
                }
                if (w.isSpace() && current.isEmpty()) {
                    w = new Word(Component.literal((String)" ").withStyle(w.component.getStyle()), false);
                    wWidth = spaceWidth;
                    words.set(i, w);
                }
                current.add(w);
                used += wWidth;
                ++i;
            }
            if (!current.isEmpty()) {
                TextJustificator.dropTrailingSpaces(current);
                lines.add(current);
            }
            for (int li = 0; li < lines.size(); ++li) {
                boolean justify = entry.isJustify() && li < lines.size() - 1;
                result.add(new LayoutLine((List)lines.get(li), justify));
            }
        }
        return result;
    }

    public static void renderJustifiedDescriptionWithStatBoxes(GuiGraphics graphics, int startX, int startY, int maximumLineWidth, Font font, List<LayoutLine> layoutLines) {
        StringSplitter splitter = font.getSplitter();
        int spaceWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)" ", (Style)Style.EMPTY)));
        int y = startY;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        for (LayoutLine line : layoutLines) {
            List<Word> words = line.words();
            if (words.isEmpty()) {
                y += lineHeight + 1;
                continue;
            }
            boolean justify = line.justify();
            int totalW = 0;
            int spaceSlots = 0;
            for (Word word : words) {
                if (word.isSpace()) {
                    totalW += spaceWidth;
                    ++spaceSlots;
                    continue;
                }
                int width = (int)Math.ceil(splitter.stringWidth((FormattedText)word.component)) + (word.isDynamic ? 4 : 0);
                totalW += width;
            }
            int x = startX;
            if (!justify || spaceSlots == 0 || totalW >= maximumLineWidth) {
                for (Word w2 : words) {
                    int color;
                    if (w2.isSpace()) {
                        x += spaceWidth;
                        continue;
                    }
                    int textWidth = (int)Math.ceil(splitter.stringWidth((FormattedText)w2.component));
                    Style style = w2.component.getStyle();
                    int n = color = style.getColor() != null ? style.getColor().getValue() : 7548704;
                    if (w2.isDynamic) {
                        graphics.fill(x - 1, y - 1, x + textWidth + 4, y, 0xFF000000 | color);
                        graphics.fill(x - 1, y + lineHeight, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.fill(x - 1, y - 1, x, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.fill(x + textWidth + 3, y - 1, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)w2.component), x + 2, y + 1, color, false);
                        x += textWidth + 5;
                        continue;
                    }
                    graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)w2.component), x, y, color, false);
                    x += textWidth;
                }
            } else {
                int n = maximumLineWidth - totalW;
                int extraSpacesTotal = Math.max(0, n / spaceWidth);
                int base = extraSpacesTotal / spaceSlots;
                int rem = extraSpacesTotal % spaceSlots;
                int seen = 0;
                for (int i = 0; i < words.size(); ++i) {
                    int color;
                    Word w = words.get(i);
                    if (w.isSpace()) {
                        int add = base + (seen < rem ? 1 : 0);
                        ++seen;
                        x += spaceWidth + add * spaceWidth;
                        continue;
                    }
                    int textWidth = (int)Math.ceil(splitter.stringWidth((FormattedText)w.component));
                    Style style = w.component.getStyle();
                    int n2 = color = style.getColor() != null ? style.getColor().getValue() : 7548704;
                    if (w.isDynamic) {
                        graphics.fill(x - 1, y - 1, x + textWidth + 4, y, 0xFF000000 | color);
                        graphics.fill(x - 1, y + lineHeight, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.fill(x - 1, y - 1, x, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.fill(x + textWidth + 3, y - 1, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                        graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)w.component), x + 2, y + 1, color, false);
                        x += textWidth + 5;
                        continue;
                    }
                    graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)w.component), x, y, color, false);
                    x += textWidth;
                }
            }
            y += lineHeight + 1;
        }
    }

    private static void tokenizeLiteral(String s, Style style, List<Word> out) {
        Matcher m = SPACE_RE.matcher(s);
        int last = 0;
        while (m.find()) {
            if (m.start() > last) {
                out.add(new Word(Component.literal((String)s.substring(last, m.start())).withStyle(style), false));
            }
            out.add(new Word(Component.literal((String)m.group()).withStyle(style), false));
            last = m.end();
        }
        if (last < s.length()) {
            out.add(new Word(Component.literal((String)s.substring(last)).withStyle(style), false));
        }
    }

    private static void dropTrailingSpaces(List<Word> line) {
        while (!line.isEmpty() && line.getLast().isSpace()) {
            line.removeLast();
        }
    }

    private static int fitPrefixByWidth(StringSplitter splitter, String s, Style style, float width) {
        int next;
        float w;
        if (width <= 0.0f || s.isEmpty()) {
            return 0;
        }
        int i = 0;
        int lastGood = 0;
        while (i < s.length() && !((w = splitter.stringWidth(FormattedText.of((String)s.substring(0, next = TextJustificator.firstCodePointEnd(s, i)), (Style)style))) > width)) {
            lastGood = next;
            i = next;
        }
        return lastGood;
    }

    private static int firstCodePointEnd(String s, int start) {
        return s.offsetByCodePoints(start, 1);
    }

    private static final class Token {
        final String raw;
        final Style style;
        final boolean isSpace;

        Token(String raw, Style style, boolean isSpace) {
            this.raw = raw;
            this.style = style;
            this.isSpace = isSpace;
        }

        FormattedText asFT() {
            return FormattedText.of((String)this.raw, (Style)this.style);
        }
    }

    public static final class LineEntry {
        private MutableComponent rawLine;
        private final boolean justify;

        public LineEntry(MutableComponent rawLine, boolean justify) {
            this.rawLine = rawLine;
            this.justify = justify;
        }

        public MutableComponent getRawLine() {
            return this.rawLine;
        }

        public void setRawLine(MutableComponent rawLine) {
            this.rawLine = rawLine;
        }

        public boolean isJustify() {
            return this.justify;
        }
    }

    public static final class LayoutLine {
        private final List<Word> words;
        private final boolean justify;

        public LayoutLine(List<Word> words, boolean justify) {
            this.words = words;
            this.justify = justify;
        }

        public List<Word> words() {
            return this.words;
        }

        public boolean justify() {
            return this.justify;
        }
    }

    public static final class Word {
        public final MutableComponent component;
        public final boolean isDynamic;

        public Word(MutableComponent component, boolean isDynamic) {
            this.component = component;
            this.isDynamic = isDynamic;
        }

        public boolean isSpace() {
            return this.component.getString().trim().isEmpty();
        }
    }
}

