/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.ScrollbarWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.misc.TextJustificator;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.DescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.utils.data.GUIScissors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AbilityDescriptionContainerWidget
extends DescriptionContainerWidget {
    private static final int VERTICAL_PADDING = 1;

    public AbilityDescriptionContainerWidget(DescriptionScreen screen) {
        super(screen);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        LocalPlayer player = this.minecraft.player;
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)this.getScreen();
        ItemStack stack = screen.getStack();
        if (stack == null || !(stack.getItem() instanceof IRelicItem) || player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        GUIScissors.begin(this.getX(), this.getY() - 1, this.getWidth(), this.getHeight() + 1);
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        DescriptionData data = this.constructDescriptionData();
        List<TextJustificator.LayoutLine> layout = TextJustificator.layoutJustifiedLines(this.minecraft.font, data.rawLines(), data.dynamicComponents(), 320);
        ScrollbarWidget scroll = this.getScrollbar();
        if (scroll != null) {
            Objects.requireNonNull(this.minecraft.font);
            int lineStep = 9 + 1;
            int totalLines = layout.size();
            int overflowLines = Math.max(0, totalLines - 9);
            int maxScrollPx = overflowLines * lineStep + 3;
            double offset = scroll.getScrollPosition(partialTick);
            double shiftY = offset * (double)maxScrollPx;
            poseStack.translate(0.0, -shiftY, 0.0);
        }
        TextJustificator.renderJustifiedDescriptionWithStatBoxes(guiGraphics, (this.getX() + 7) * 2, this.getY() * 2, 320, this.minecraft.font, layout);
        poseStack.popPose();
        GUIScissors.end();
    }

    public DescriptionData constructDescriptionData() {
        Item item;
        LocalPlayer player = this.minecraft.player;
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)this.getScreen();
        ItemStack stack = screen.getStack();
        String ability = screen.getSelectedAbility();
        if (player == null || stack == null || !((item = stack.getItem()) instanceof IRelicItem)) {
            return new DescriptionData(List.of(), List.of());
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityTemplate template = relic.getAbilityTemplate((LivingEntity)player, stack, ability);
        int level = relic.getAbilityLevel((LivingEntity)player, stack, ability);
        boolean wantsUpgrade = screen.getUpgradeButton() != null && screen.getUpgradeButton().isHovered() && relic.mayUpgrade((LivingEntity)player, stack, ability);
        boolean wantsReroll = screen.getRerollButton() != null && screen.getRerollButton().isHovered() && relic.mayReroll((LivingEntity)player, stack, ability);
        boolean wantsReset = screen.getResetButton() != null && screen.getResetButton().isHovered() && relic.mayReset((LivingEntity)player, stack, ability);
        List<MutableComponent> dynamicComponents = template.getStats().values().stream().map(stat -> {
            double rawValue = relic.getStatValueForLevel((LivingEntity)player, stack, ability, stat.getId(), wantsUpgrade ? level + 1 : (wantsReset ? 0 : level));
            String txt = stat.getFormatValue().apply(rawValue).toString();
            if (txt.endsWith(".0")) {
                txt = txt.substring(0, txt.length() - 2);
            }
            MutableComponent result = Component.literal((String)txt).withStyle(ChatFormatting.BOLD).withColor(wantsUpgrade ? DescriptionUtils.POSITIVE_COLOR(true) : (wantsReroll ? DescriptionUtils.NEUTRAL_COLOR(true) : (wantsReset ? DescriptionUtils.NEGATIVE_COLOR(true) : 7548704)));
            if (wantsReroll) {
                result = result.withStyle(ChatFormatting.OBFUSCATED);
            }
            return result;
        }).toList();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        String key = "relics.description." + itemId + ".ability." + ability + "." + (String)(relic.getAbilityTemplate((LivingEntity)player, stack, ability).getModes().isEmpty() ? "description" : relic.getAbilityMode((LivingEntity)player, stack, ability) + ".description");
        String[] tokens = (String[])IntStream.rangeClosed(1, dynamicComponents.size()).mapToObj(i -> "%" + i + "$s").toArray(String[]::new);
        MutableComponent descriptionComponent = Component.translatable((String)key, (Object[])tokens);
        ArrayList<TextJustificator.LineEntry> rawLines = new ArrayList<TextJustificator.LineEntry>();
        rawLines.add(new TextJustificator.LineEntry(descriptionComponent, true));
        for (Map.Entry entry : template.getRankModifiers().entries()) {
            rawLines.add(new TextJustificator.LineEntry(Component.literal((String)""), false));
            rawLines.add(new TextJustificator.LineEntry(Component.translatable((String)"relics.description.ability.rank_modifier.condition.rank", (Object[])new Object[]{entry.getKey()}).withStyle(ChatFormatting.BOLD), false));
            MutableComponent description = Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)("relics.description." + itemId + ".ability." + ability + ".rank_modifier." + (String)entry.getValue()), (Object[])tokens));
            if (relic.getRelicRank((LivingEntity)player, stack) < (Integer)entry.getKey()) {
                description = ScreenUtils.randomizeAllCharacters(description, this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
            }
            rawLines.add(new TextJustificator.LineEntry(description, true));
        }
        if (!relic.isAbilityUnlocked((LivingEntity)player, stack, ability)) {
            for (TextJustificator.LineEntry line : rawLines) {
                line.setRawLine(ScreenUtils.randomizeAllCharacters(line.getRawLine(), this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true))));
            }
        }
        return new DescriptionData(rawLines, dynamicComponents);
    }

    @Override
    public int getContentHeight() {
        DescriptionData data = this.constructDescriptionData();
        List<TextJustificator.LayoutLine> lines = TextJustificator.layoutJustifiedLines(this.minecraft.font, data.rawLines(), data.dynamicComponents(), 320);
        Objects.requireNonNull(this.minecraft.font);
        int step = 9 + 1;
        return lines.size() * step / 2 + 6;
    }

    public record DescriptionData(List<TextJustificator.LineEntry> rawLines, List<MutableComponent> dynamicComponents) {
    }
}

