/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BigRelicCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    public static final List<ResourceLocation> BACKGROUNDS = Stream.of("blue", "cyan", "green", "light_blue", "orange", "magenta", "purple", "red", "yellow").map(color -> ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/general/backgrounds/" + color + ".png"))).toList();
    private RelicDescriptionScreen screen;

    public BigRelicCardWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 50, 87);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        LocalPlayer player = this.minecraft.player;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -100.0f);
        float color = (float)((double)1.05f + Math.sin((float)player.tickCount * 0.25f) * (double)0.1f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        ResourceLocation background = BigRelicCardWidget.pickClosestBackground(stack, BACKGROUNDS);
        if (background != null) {
            GUIRenderer.begin(background, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 8, this.getY() + 20).end();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.translate(0.0f, 0.0f, 100.0f);
        GUIRenderer.begin(DescriptionTextures.BIG_CARD_FRAME_UNLOCKED_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        int xOff = 0;
        if (relic.hasUnlockedUpgradeableAbility((LivingEntity)player, stack)) {
            for (int i = 0; i < 5; ++i) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_HOLE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).end();
                xOff += 8;
            }
            xOff = 0;
            int quality = relic.calculateRelicQuality((LivingEntity)player, stack);
            boolean isAliquot = quality % 2 == 1;
            int i = 0;
            while ((double)i < Math.floor((double)quality / 2.0)) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).end();
                xOff += 8;
                ++i;
            }
            if (isAliquot) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).patternSize(4, 7).texSize(8, 7).end();
            }
        }
        poseStack.pushPose();
        float scale = 1.75f;
        poseStack.translate((double)((float)(this.getX() + 11) + 8.0f * scale), (double)(this.getY() + 31) + Math.sin(((float)player.tickCount + pPartialTick) * 0.1f) * 2.0 + (double)(8.0f * scale), 0.0);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.05f) * 5.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.075f) * 25.0f));
        poseStack.translate(-8.0f * scale, -8.0f * scale, -150.0f * scale);
        poseStack.scale(scale, scale, scale);
        guiGraphics.renderItem(stack, 0, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 1.0f);
        MutableComponent levelComponent = Component.literal((String)String.valueOf(relic.getRelicLevel((LivingEntity)player, stack))).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(this.minecraft.font, (Component)levelComponent, (int)(((float)this.getX() + 26.5f) * 1.33f - (float)this.minecraft.font.width((FormattedText)levelComponent) / 2.0f), (int)(((float)this.getY() + 4.5f) * 1.33f), 16769656, false);
        poseStack.popPose();
        if (this.isHovered() && relic.hasUnlockedUpgradeableAbility((LivingEntity)player, stack)) {
            GUIRenderer.begin(DescriptionTextures.BIG_CARD_FRAME_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
        poseStack.popPose();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int getTextureColor(ResourceLocation textureLocation) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Resource resource = resourceManager.getResource(textureLocation).orElse(null);
        if (resource == null) {
            return 0;
        }
        try (InputStream in = resource.open();){
            int n;
            block15: {
                NativeImage img = NativeImage.read((InputStream)in);
                try {
                    n = BigRelicCardWidget.averageColor(img.getWidth(), img.getHeight(), (arg_0, arg_1) -> ((NativeImage)img).getPixelRGBA(arg_0, arg_1));
                    if (img == null) break block15;
                }
                catch (Throwable throwable) {
                    if (img != null) {
                        try {
                            img.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                img.close();
            }
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getItemColor(ItemStack itemStack) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer renderer = mc.getItemRenderer();
        BakedModel model = renderer.getModel(itemStack, (Level)mc.level, (LivingEntity)mc.player, 0);
        TextureAtlasSprite sprite = model.getParticleIcon(ModelData.EMPTY);
        int w = sprite.contents().width();
        int h = sprite.contents().height();
        return BigRelicCardWidget.averageColor(w, h, (x, y) -> sprite.getPixelRGBA(0, x, y));
    }

    public static double colorDistance(int colorA, int colorB) {
        int rA = colorA >>> 16 & 0xFF;
        int gA = colorA >>> 8 & 0xFF;
        int bA = colorA & 0xFF;
        int rB = colorB >>> 16 & 0xFF;
        int gB = colorB >>> 8 & 0xFF;
        int bB = colorB & 0xFF;
        int dr = rA - rB;
        int dg = gA - gB;
        int db = bA - bB;
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    public static ResourceLocation pickClosestBackground(ItemStack itemStack, List<ResourceLocation> backgroundTextures) {
        int itemColor = BigRelicCardWidget.getItemColor(itemStack);
        return backgroundTextures.stream().min(Comparator.comparingDouble(tex -> BigRelicCardWidget.colorDistance(itemColor, BigRelicCardWidget.getTextureColor(tex)))).orElse(null);
    }

    private static int averageColor(int width, int height, PixelSampler sampler) {
        long sumR = 0L;
        long sumG = 0L;
        long sumB = 0L;
        long count = 0L;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int p = sampler.sample(x, y);
                if (FastColor.ABGR32.alpha((int)p) < 16) continue;
                sumR += (long)FastColor.ABGR32.red((int)p);
                sumG += (long)FastColor.ABGR32.green((int)p);
                sumB += (long)FastColor.ABGR32.blue((int)p);
                ++count;
            }
        }
        if (count == 0L) {
            return 0;
        }
        int avgR = (int)(sumR / count);
        int avgG = (int)(sumG / count);
        int avgB = (int)(sumB / count);
        return avgR << 16 | avgG << 8 | avgB;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).hasUnlockedUpgradeableAbility((LivingEntity)this.minecraft.player, stack)) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.info.level").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + relic.getRelicLevel((LivingEntity)this.minecraft.player, stack) + "/" + relic.calculateRelicMaxLevel((LivingEntity)this.minecraft.player, stack)), Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.info.quality").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + MathUtils.round((float)relic.calculateRelicQuality((LivingEntity)this.minecraft.player, stack) / 2.0f, 1) + "/" + relic.getRelicMaxQuality((LivingEntity)this.minecraft.player, stack) / 2), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"relics.description.researching.relic.info.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, this.getX() - renderWidth / 2 + 16, this.getY() + this.getHeight() - 2);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (this.getX() - renderWidth / 2 + 14 + 12) * 2, (this.getY() + yOff + this.getHeight() - 2 + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    @FunctionalInterface
    private static interface PixelSampler {
        public int sample(int var1, int var2);
    }
}

