/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.TabWidget;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.GUIScissors;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class BookmarkWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private DescriptionScreen screen;
    public double slideProgress = 0.0;
    public double animationProgress = 0.0;
    public Tween hoverTween;
    private boolean hasHovered = false;

    public BookmarkWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, 16, 20);
        this.screen = screen;
    }

    public abstract String getId();

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = this.minecraft.player;
        GUIScissors.begin(this.getX() - 1, this.getY() - 3, this.getWidth() + 2, this.getHeight() + 3);
        poseStack.pushPose();
        poseStack.translate((double)((float)this.getX() + (float)this.getWidth() / 2.0f), (double)(this.getY() + this.getHeight() + 1) - this.slideProgress, 0.0);
        if (this.isLocked()) {
            poseStack.translate(0.0f, 10.0f, 0.0f);
            GUIRenderer.begin(this instanceof TabWidget ? DescriptionTextures.TAB : DescriptionTextures.PAGE, poseStack).anchor(SpriteAnchor.BOTTOM_CENTER).end();
        } else {
            int texWidth = 16;
            int patternHeight = 21;
            GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/general/bookmarks/" + this.getId() + ".png")), poseStack).texOff(0, (int)(Math.floor((double)this.getAnimationSegments() * this.animationProgress) * (double)patternHeight)).patternSize(texWidth, patternHeight).anchor(SpriteAnchor.BOTTOM_CENTER).end();
            if (this.isHovered()) {
                GUIRenderer.begin(this instanceof TabWidget ? DescriptionTextures.TAB_OUTLINE : DescriptionTextures.PAGE_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_CENTER).pos(0.0f, -(this.getHeight() + 2)).end();
            }
        }
        poseStack.popPose();
        GUIScissors.end();
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            super.playDownSound(handler);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)("relics.description.researching.bookmarks." + this.getId())).withStyle(ChatFormatting.BOLD)});
        for (MutableComponent entry : entries) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        boolean hovered = this.isHovered();
        float animationDuration = (float)this.getAnimationSegments() * 0.5f / 20.0f;
        if (hovered && !this.hasHovered) {
            this.hasHovered = true;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setParallel(true);
            this.hoverTween.tweenMethod(this::setSlideProgress, (Object)0.0, (Object)1.0, 0.075).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUART);
            this.hoverTween.tweenMethod(this::setAnimationProgress, (Object)0.0, (Object)1.0, (double)animationDuration * (1.0 - this.animationProgress)).setTransitionType(TransitionType.LINEAR);
            this.hoverTween.start();
        } else if (!hovered && this.hasHovered) {
            this.hasHovered = false;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setParallel(true);
            this.hoverTween.tweenMethod(this::setSlideProgress, (Object)1.0, (Object)0.0, 0.15).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUART);
            this.hoverTween.tweenMethod(this::setAnimationProgress, (Object)1.0, (Object)0.0, (double)animationDuration * this.animationProgress).setTransitionType(TransitionType.LINEAR);
            this.hoverTween.start();
        }
    }

    private int getAnimationSegments() {
        Minecraft.getInstance().getTextureManager().getTexture(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/general/bookmarks/" + this.getId() + ".png"))).bind();
        int texHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        int patternHeight = 21;
        return texHeight / patternHeight - 1;
    }

    @Generated
    public DescriptionScreen getScreen() {
        return this.screen;
    }

    @Generated
    public void setSlideProgress(double slideProgress) {
        this.slideProgress = slideProgress;
    }

    @Generated
    public void setAnimationProgress(double animationProgress) {
        this.animationProgress = animationProgress;
    }
}

