/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.AbstractRelicActionWidget;
import it.hurts.sskirillss.relics.init.RelicsHotkeys;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RankupRelicActionWidget
extends AbstractRelicActionWidget {
    public RankupRelicActionWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, PacketRelicTweak.Operation.RANKUP, screen);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getScreen().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerRankup((Player)this.minecraft.player, this.getScreen().getStack());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.TABLE_REROLL.get()), (float)1.0f));
        }
    }

    @Override
    public void onTick() {
        super.onTick();
    }

    @Override
    public List<MutableComponent> buildDescription() {
        int maxRank;
        List<MutableComponent> description = super.buildDescription();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        int rank = relic.getRelicRank((LivingEntity)player, stack);
        boolean isMaxRank = rank >= (maxRank = relic.getRelicTemplate((LivingEntity)player, stack).getLeveling().getMaxRank());
        int level = relic.getRelicLevel((LivingEntity)player, stack);
        int maxLevel = relic.calculateRelicMaxLevel((LivingEntity)player, stack);
        boolean isMaxLevel = level >= maxLevel;
        int key = RelicsHotkeys.RESEARCH_RELIC.getKey().getValue();
        boolean hasShiftDown = key != -1 && InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)key);
        MutableComponent newLine = Component.literal((String)" ");
        description.add(Component.translatable((String)"relics.description.relic.rankup.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
        description.add(newLine);
        if (!isMaxRank) {
            description.add(Component.translatable((String)"relics.description.general.cost.title").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
            description.add(Component.literal((String)"   \u25cf ").append((Component)Component.translatable((String)"relics.description.relic.rankup.cost.entry_1", (Object[])new Object[]{maxLevel}).withColor(isMaxLevel ? DescriptionUtils.POSITIVE_COLOR(true) : DescriptionUtils.NEGATIVE_COLOR(true))));
            if (isMaxLevel) {
                description.add(newLine);
                description.add(Component.translatable((String)"relics.description.relic.rankup.warning", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName().getString()}).withColor(hasShiftDown ? DescriptionUtils.NEUTRAL_COLOR(true) : DescriptionUtils.NEGATIVE_COLOR(true)));
            }
        } else {
            description.add(Component.empty().append((Component)Component.translatable((String)"relics.description.relic.rankup.max_rank", (Object[])new Object[]{maxLevel}).withColor(DescriptionUtils.NEGATIVE_COLOR(true))));
        }
        description.add(newLine);
        if (hasShiftDown) {
            description.add(Component.translatable((String)"relics.description.relic.rankup.description").withStyle(ChatFormatting.ITALIC));
        } else {
            description.add(Component.translatable((String)"relics.general.hold_shift", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName().getString()}));
        }
        return description;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList tooltip = new ArrayList();
        PoseStack poseStack = guiGraphics.pose();
        int maxWidth = 150;
        int renderWidth = 0;
        for (MutableComponent entry : this.buildDescription()) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

