/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.research;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.misc.TextJustificator;
import it.hurts.sskirillss.relics.client.screen.description.research.misc.BurnPoint;
import it.hurts.sskirillss.relics.client.screen.description.research.particles.ResearchParticleData;
import it.hurts.sskirillss.relics.client.screen.description.research.widgets.HintWidget;
import it.hurts.sskirillss.relics.client.screen.description.research.widgets.StarWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.research.StarData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.research.PacketManageLink;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector2f;

@OnlyIn(value=Dist.CLIENT)
public class AbilityResearchScreen
extends DescriptionScreen {
    public final String ability;
    @Nullable
    public StarData selectedStar;
    private List<BurnPoint> points = new ArrayList<BurnPoint>();
    private List<StarWidget> stars = new ArrayList<StarWidget>();
    private final int maxResearchProgress = 40;
    private int researchProgress = 0;
    public final int backgroundHeight = 256;
    public final int backgroundWidth = 418;
    public int x;
    public int y;

    public AbilityResearchScreen(Player player, int container, int slot, Screen screen, String ability) {
        super(player, container, slot, screen);
        this.ability = ability;
    }

    public int getTotalConnectionsCount(StarData star) {
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0;
        }
        IRelicItem relic = (IRelicItem)item;
        return relic.getAbilityTemplate((LivingEntity)this.minecraft.player, this.stack, this.ability).getResearchTemplate().getConnectedStars(star).size();
    }

    public int getOccupiedConnectionsCount(StarData star) {
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0;
        }
        IRelicItem relic = (IRelicItem)item;
        int index = star.getIndex();
        return (int)relic.getResearchLinks((LivingEntity)this.minecraft.player, this.stack, this.ability).entries().stream().filter(entry -> (Integer)entry.getKey() == index || (Integer)entry.getValue() == index).map(entry -> (Integer)entry.getKey() < (Integer)entry.getValue() ? String.valueOf(entry.getKey()) + "-" + String.valueOf(entry.getValue()) : String.valueOf(entry.getValue()) + "-" + String.valueOf(entry.getKey())).distinct().count();
    }

    @Override
    protected void init() {
        Item item;
        super.init();
        this.x = (this.width - this.backgroundWidth) / 2;
        this.y = (this.height - this.backgroundHeight) / 2;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        this.researchProgress = 0;
        this.stars.clear();
        this.points.clear();
        this.addRenderableWidget((GuiEventListener)new HintWidget(this.x + 192, this.y + 198, this));
        int starSize = 17;
        for (StarData entry : relic.getAbilityTemplate((LivingEntity)this.minecraft.player, this.stack, this.ability).getResearchTemplate().getStars().values()) {
            this.stars.add((StarWidget)this.addWidget((GuiEventListener)new StarWidget((int)((float)(this.x + 67) + (float)entry.getX() * 5.0f - (float)starSize / 2.0f), (int)((float)(this.y + 54) + (float)entry.getY() * 5.0f - (float)starSize / 2.0f), this, entry)));
        }
    }

    public void rebuildWidgets() {
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
        super.rebuildWidgets();
    }

    @Override
    public void tick() {
        Integer end;
        Integer start;
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        super.tick();
        RandomSource random = this.minecraft.player.getRandom();
        if (relic.isAbilityResearched((LivingEntity)this.minecraft.player, this.stack, this.ability) && this.researchProgress >= 0 && this.researchProgress < 40) {
            ++this.researchProgress;
            if (this.researchProgress % 3 == 0) {
                ResearchTemplate researchData = relic.getResearchTemplate((LivingEntity)this.minecraft.player, this.stack, this.ability);
                for (Map.Entry entry2 : relic.getResearchLinks((LivingEntity)this.minecraft.player, this.stack, this.ability).entries()) {
                    start = researchData.getStars().get(entry2.getKey()).getPos();
                    end = researchData.getStars().get(entry2.getValue()).getPos();
                    this.executeForConnection((Vec2)start, (Vec2)end, 0.75f, point -> ParticleStorage.addParticle(this, new ResearchParticleData(new Color(100 + random.nextInt(150), random.nextInt(25), 200 + random.nextInt(50)), point.x + MathUtils.randomFloat(random), point.y + MathUtils.randomFloat(random), 1.0f + random.nextFloat() * 0.25f, 20 + random.nextInt(40 + this.researchProgress), random.nextFloat() * 0.025f)));
                }
            }
        }
        if (this.minecraft.player.tickCount % 3 == 0) {
            Multimap<Integer, Integer> links = relic.getResearchLinks((LivingEntity)this.minecraft.player, this.stack, this.ability);
            for (Map.Entry entry3 : links.entries()) {
                start = (Integer)entry3.getKey();
                end = (Integer)entry3.getValue();
                Optional<StarWidget> startStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == start.intValue()).findFirst();
                Optional<StarWidget> endStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == end.intValue()).findFirst();
                if (!startStar.isPresent() || !endStar.isPresent()) continue;
                this.executeForConnection(startStar.get().getStar().getPos(), endStar.get().getStar().getPos(), 1.1f, point -> this.addStaticPoint((int)point.x, (int)point.y, 0.06f, (Pair<Integer, Integer>)Pair.of((Object)start, (Object)end)));
            }
            for (Pair pair : this.points.stream().map(BurnPoint::getLink).filter(Objects::nonNull).toList()) {
                start = (Integer)pair.getKey();
                if (links.containsEntry((Object)start, (Object)(end = (Integer)pair.getValue())) || links.containsEntry((Object)end, (Object)start)) continue;
                this.points.stream().filter(point -> point.getLink() != null && ((Integer)point.getLink().getKey()).equals(start) && ((Integer)point.getLink().getValue()).equals(end)).forEach(entry -> {
                    entry.setLink(null);
                    entry.setTicker(point -> {
                        int time = point.getLifeTime();
                        if (time <= 0) {
                            return;
                        }
                        point.setLifeTime(--time);
                        float diff = Mth.clamp((float)point.getLifeTime(), (float)0.01f, (float)point.getMaxLifeTime()) / (float)point.getMaxLifeTime();
                        point.setScaleO(point.getScale());
                        point.setScale(point.getScale() * diff);
                    });
                });
            }
        }
        for (BurnPoint point2 : this.points) {
            point2.tick();
        }
    }

    private void addAbstractPoint(BurnPoint point) {
        if (this.points.size() >= 256) {
            return;
        }
        Optional<BurnPoint> optional = this.points.stream().filter(entry -> entry.getX() == point.getX() && entry.getY() == point.getY()).findAny();
        if (optional.isPresent()) {
            if (optional.get().getLifeTime() > 0) {
                return;
            }
        } else {
            optional = this.points.stream().filter(entry -> entry.getLifeTime() <= 0).findFirst();
        }
        if (optional.isEmpty()) {
            this.points.add(point);
        } else {
            optional.get().set(point);
        }
    }

    private void addLivingPoint(int x, int y, int lifeTime, float scale) {
        this.addAbstractPoint(BurnPoint.builder(x, y, scale).lifeTime(lifeTime).maxLifeTime(lifeTime).ticker(point -> {
            int time = point.getLifeTime();
            if (time < 0) {
                return;
            }
            point.setLifeTime(--time);
            float diff = Mth.clamp((float)point.getLifeTime(), (float)0.01f, (float)point.getMaxLifeTime()) / (float)point.getMaxLifeTime();
            point.setScaleO(point.getScale());
            point.setScale(point.getMaxScale() * diff);
        }).build());
    }

    private void addStaticPoint(int x, int y, float scale, Pair<Integer, Integer> link) {
        this.addAbstractPoint(BurnPoint.builder(x, y, scale).scale(0.0f).lifeTime(1).maxLifeTime(8).ticker(point -> {
            point.setScaleO(point.getScale());
            if (this.researchProgress <= 0) {
                int time = point.getLifeTime();
                if (time >= point.getMaxLifeTime()) {
                    return;
                }
                point.setLifeTime(++time);
                float diff = Mth.clamp((float)point.getLifeTime(), (float)0.01f, (float)point.getMaxLifeTime()) / (float)point.getMaxLifeTime();
                point.setScale(point.getMaxScale() * diff);
            } else {
                point.setScale(point.getScale() + (float)this.researchProgress * 7.5E-4f);
            }
        }).link(link).build());
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        block11: {
            block10: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.minecraft.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block10;
                relic = (IRelicItem)item;
                if (player != null) break block11;
            }
            return;
        }
        RelicTemplate relicData = relic.getRelicTemplate((LivingEntity)player, this.stack);
        if (relicData == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float color = (float)(0.5 + Math.sin(((float)player.tickCount + pPartialTick) * 0.1f) * (double)0.1f);
        GUIRenderer.begin(DescriptionTextures.getAbilityCardTexture(this.stack, this.ability), poseStack).anchor(SpriteAnchor.TOP_LEFT).color(color, color, color, 1.0f).pos(this.x + 67, this.y + 54).texSize(110, 155).end();
        ResearchTemplate researchData = relic.getAbilityTemplate((LivingEntity)player, this.stack, this.ability).getResearchTemplate();
        for (Map.Entry link : relic.getResearchLinks((LivingEntity)player, this.stack, this.ability).entries()) {
            Vec2 start = researchData.getStars().get(link.getKey()).getPos();
            Vec2 end = researchData.getStars().get(link.getValue()).getPos();
            this.drawLink(poseStack, this.getScaledPos(start), this.getScaledPos(end), pMouseX, pMouseY, pPartialTick);
        }
        if (this.selectedStar != null) {
            Vec2 pos = this.selectedStar.getPos();
            this.drawLink(poseStack, this.getScaledPos(pos), new Vec2((float)pMouseX, (float)pMouseY), pMouseX, pMouseY, pPartialTick);
        }
        for (StarWidget widget : this.stars) {
            widget.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.RESEARCH_FOG);
        ArrayList positions = Lists.newArrayList((Object[])new Vector2f[]{new Vector2f((float)pMouseX, (float)pMouseY)});
        ArrayList scales = Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.15f)});
        ArrayList noises = Lists.newArrayList((Object[])new Float[]{Float.valueOf(10.0f)});
        this.addLivingPoint(pMouseX, pMouseY, 3, 0.1f);
        for (BurnPoint point : this.points) {
            boolean shouldRender = point.getLifeTime() > 0;
            positions.add(new Vector2f(shouldRender ? point.getX() : -100.0f, shouldRender ? point.getY() : -100.0f));
            scales.add(Float.valueOf(Mth.lerp((float)pPartialTick, (float)point.getScaleO(), (float)point.getScale())));
            noises.add(Float.valueOf(point.getScale() * 75.0f));
        }
        poseStack.translate(0.0f, 0.0f, 5000.0f);
        RenderUtils.renderRevealingPanel(poseStack, this.x + 67, this.y + 54, 110.0f, 155.0f, positions, scales, noises, ((float)player.tickCount + pPartialTick) / 50.0f);
        GUIRenderer.begin(DescriptionTextures.RESEARCH_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.x + 60, this.y + 45).end();
        poseStack.popPose();
        poseStack.pushPose();
        MutableComponent title = Component.translatable((String)"relics.description.ability.research.rules").withStyle(ChatFormatting.BOLD);
        poseStack.translate((float)((int)((float)(this.x + 184) + 51.0f - (float)this.minecraft.font.width((FormattedText)title) / 2.0f / 1.3f)), (float)(this.y + 67), 0.0f);
        poseStack.scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(this.minecraft.font, (Component)title, 0, 0, 7548704, false);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((float)(this.x + 191), (float)(this.y + 85), 0.0f);
        poseStack.scale(0.5f, 0.5f, 1.0f);
        int yOff = 0;
        ArrayList<MutableComponent> description = new ArrayList<MutableComponent>();
        description.add(Component.literal((String)"1. ").append((Component)Component.translatable((String)"relics.description.ability.research.rule_1.title")).withStyle(ChatFormatting.BOLD).withColor(DescriptionUtils.POSITIVE_COLOR(true)));
        description.add(Component.translatable((String)"relics.description.ability.research.rule_1.description"));
        description.add(Component.literal((String)" "));
        description.add(Component.literal((String)"2. ").append((Component)Component.translatable((String)"relics.description.ability.research.rule_2.title")).withStyle(ChatFormatting.BOLD).withColor(DescriptionUtils.NEUTRAL_COLOR(true)));
        description.add(Component.translatable((String)"relics.description.ability.research.rule_2.description"));
        description.add(Component.literal((String)" "));
        description.add(Component.literal((String)"3. ").append((Component)Component.translatable((String)"relics.description.ability.research.rule_3.title")).withStyle(ChatFormatting.BOLD).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
        description.add(Component.translatable((String)"relics.description.ability.research.rule_3.description"));
        for (MutableComponent component : description) {
            for (FormattedCharSequence line : TextJustificator.justifyStyledText((Component)component, 180)) {
                guiGraphics.drawString(this.minecraft.font, line, 0, yOff, 7548704, false);
                yOff += 10;
            }
        }
        poseStack.popPose();
    }

    public Vec2 getScaledPos(Vec2 pos) {
        int scale = 5;
        return new Vec2((float)(this.x + 67) + pos.x * (float)scale, (float)(this.y + 54) + pos.y * (float)scale);
    }

    private void drawLink(PoseStack poseStack, Vec2 start, Vec2 end, int mouseX, int mouseY, float partialTick) {
        Item item = this.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        poseStack.pushPose();
        float offset = (float)(Math.sin(((float)this.minecraft.player.tickCount + partialTick + start.length()) * 0.2f) * (double)0.1f);
        float color = 1.25f + offset;
        if (!relic.isAbilityResearched((LivingEntity)this.minecraft.player, this.stack, this.ability) && this.isHoveringConnection(start, end, mouseX, mouseY)) {
            RenderSystem.setShaderColor((float)color, (float)0.25f, (float)0.25f, (float)(0.75f + offset));
        } else {
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)(0.75f + offset));
        }
        RenderSystem.enableBlend();
        int width = 6;
        int height = 4;
        int distance = (int)Math.sqrt(start.distanceToSqr(end));
        poseStack.translate(start.x, start.y, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(this.getAngle(start, end)));
        poseStack.translate(-((float)width / 2.0f), -((float)height / 2.0f), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/research/line.png"));
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/research/line.png"), poseStack).pos(0.0f, 0.0f).texSize(width, height * 6).patternSize(distance, height).anchor(SpriteAnchor.TOP_LEFT).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2)).end();
        poseStack.mulPose(Axis.ZP.rotationDegrees(-this.getAngle(start, end)));
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private void executeForConnection(Vec2 start, Vec2 end, float step, Consumer<Vec2> task) {
        int steps = (int)(Math.sqrt(start.distanceToSqr(end)) / (double)step);
        Vec2 direction = new Vec2(end.x - start.x, end.y - start.y).normalized();
        for (int i = 0; i <= steps; ++i) {
            Vec2 point = new Vec2(direction.x * step * (float)i, direction.y * step * (float)i).add(start);
            task.accept(this.getScaledPos(point));
        }
    }

    private boolean isHoveringConnection(Vec2 start, Vec2 end, int mouseX, int mouseY) {
        float minDistance = 4.0f;
        float thickness = 4.0f;
        float x1 = start.x;
        float y1 = start.y;
        float x2 = end.x;
        float y2 = end.y;
        double distanceToStart = Math.hypot((float)mouseX - x1, (float)mouseY - y1);
        double distanceToEnd = Math.hypot((float)mouseX - x2, (float)mouseY - y2);
        if (distanceToStart < (double)minDistance || distanceToEnd < (double)minDistance) {
            return false;
        }
        double collinearity = (x2 - x1) * ((float)mouseY - y1) - (y2 - y1) * ((float)mouseX - x1);
        double lineLength = Math.hypot(x2 - x1, y2 - y1);
        double distanceFromLine = Math.abs(collinearity / lineLength);
        if (distanceFromLine > (double)(thickness / 2.0f)) {
            return false;
        }
        return Math.min(x1, x2) - thickness / 2.0f <= (float)mouseX && (float)mouseX <= Math.max(x1, x2) + thickness / 2.0f && Math.min(y1, y2) - thickness / 2.0f <= (float)mouseY && (float)mouseY <= Math.max(y1, y2) + thickness / 2.0f;
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        IRelicItem relic;
        Item item = this.stack.getItem();
        if (item instanceof IRelicItem && !(relic = (IRelicItem)item).isAbilityResearched((LivingEntity)this.minecraft.player, this.stack, this.ability) && pButton == 0) {
            ResearchTemplate researchData = relic.getResearchTemplate((LivingEntity)this.minecraft.player, this.stack, this.ability);
            Pair toRemove = null;
            for (Map.Entry link : relic.getResearchLinks((LivingEntity)this.minecraft.player, this.stack, this.ability).entries()) {
                if (!this.isHoveringConnection(this.getScaledPos(researchData.getStars().get(link.getKey()).getPos()), this.getScaledPos(researchData.getStars().get(link.getValue()).getPos()), (int)pMouseX, (int)pMouseY)) continue;
                toRemove = Pair.of((Object)((Integer)link.getKey()), (Object)((Integer)link.getValue()));
            }
            if (toRemove != null) {
                this.removeLink((Integer)toRemove.getKey(), (Integer)toRemove.getValue());
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void addLink(int start, int end) {
        Optional<StarWidget> startStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == start).findFirst();
        Optional<StarWidget> endStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == end).findFirst();
        if (startStar.isEmpty() || endStar.isEmpty()) {
            return;
        }
        RandomSource random = this.minecraft.player.getRandom();
        NetworkHandler.sendToServer(new PacketManageLink(this.container, this.slot, this.ability, PacketManageLink.Operation.ADD, start, end));
        this.executeForConnection(startStar.get().getStar().getPos(), endStar.get().getStar().getPos(), 0.25f, point -> ParticleStorage.addParticle(this, new ResearchParticleData(new Color(100 + random.nextInt(150), random.nextInt(25), 200 + random.nextInt(50)), point.x + MathUtils.randomFloat(random), point.y + MathUtils.randomFloat(random), 1.0f + random.nextFloat() * 0.25f, 20 + random.nextInt(60), random.nextFloat() * 0.025f)));
    }

    public void removeLink(int start, int end) {
        Optional<StarWidget> startStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == start).findFirst();
        Optional<StarWidget> endStar = this.stars.stream().filter(entry -> entry.getStar().getIndex() == end).findFirst();
        if (startStar.isEmpty() || endStar.isEmpty()) {
            return;
        }
        RandomSource random = this.minecraft.player.getRandom();
        NetworkHandler.sendToServer(new PacketManageLink(this.container, this.slot, this.ability, PacketManageLink.Operation.REMOVE, start, end));
        this.executeForConnection(startStar.get().getStar().getPos(), endStar.get().getStar().getPos(), 0.1f, point -> ParticleStorage.addParticle(this, new ResearchParticleData(new Color(100 + random.nextInt(150), random.nextInt(25), 200 + random.nextInt(50)), point.x + MathUtils.randomFloat(random), point.y + MathUtils.randomFloat(random), 1.0f + random.nextFloat() * 0.25f, 10 + random.nextInt(50), random.nextFloat() * 0.01f)));
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.DISCONNECT_STARS.get()), (float)(0.75f + this.minecraft.player.getRandom().nextFloat() * 0.5f), (float)0.75f));
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        Item item = this.stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            if (pButton == 0 && this.selectedStar != null) {
                for (StarWidget widget : this.stars) {
                    if (!widget.isHovered()) continue;
                    Multimap<Integer, Integer> links = relic.getResearchLinks((LivingEntity)this.minecraft.player, this.stack, this.ability);
                    int start = this.selectedStar.getIndex();
                    int end = widget.getStar().getIndex();
                    StarData star = widget.getStar();
                    if (start == end || this.getOccupiedConnectionsCount(star) >= this.getTotalConnectionsCount(star) || links.containsEntry((Object)start, (Object)end) || links.containsEntry((Object)end, (Object)start)) continue;
                    this.addLink(start, end);
                    break;
                }
                this.selectedStar = null;
            }
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    @Override
    protected void initTopScroll() {
    }

    @Override
    protected void initBottomScroll() {
    }

    @Override
    protected void renderTopScroll(GuiGraphics guiGraphics) {
    }

    @Override
    protected void renderBottomScroll(GuiGraphics guiGraphics) {
    }

    public void onClose() {
        this.screen.rebuildWidgets();
        this.minecraft.setScreen(this.screen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public float getAngle(Vec2 from, Vec2 to) {
        float angle = (float)Math.toDegrees(Math.atan2(to.y - from.y, to.x - from.x));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

