/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;

public class ScreenUtils {
    public static final ResourceLocation ALT_FONT = ResourceLocation.withDefaultNamespace((String)"alt");
    public static final ResourceLocation ILLAGER_ALT_FONT = ResourceLocation.withDefaultNamespace((String)"illageralt");

    public static void drawTexturedTooltipBorder(GuiGraphics guiGraphics, ResourceLocation texture, int width, int height, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.getInstance().getTextureManager().bindForSetup(texture);
        int texSize = 19;
        int cornerSize = 9;
        guiGraphics.blit(texture, x, y, cornerSize, cornerSize, 0.0f, 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y, width, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize + width, y, cornerSize, cornerSize, (float)(cornerSize + 1), 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x, y + cornerSize, cornerSize, height, 0.0f, (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.blit(texture, x + width + cornerSize, y + cornerSize, cornerSize, height, (float)(cornerSize + 1), (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y + cornerSize, width, height, (float)(cornerSize + 1), (float)(cornerSize + 1), 1, 1, texSize, texSize);
        guiGraphics.blit(texture, x, y + height + cornerSize, cornerSize, cornerSize, 0.0f, (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize, y + height + cornerSize, width, cornerSize, (float)cornerSize, (float)(cornerSize + 1), 1, cornerSize, texSize, texSize);
        guiGraphics.blit(texture, x + cornerSize + width, y + cornerSize + height, cornerSize, cornerSize, (float)(cornerSize + 1), (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, boolean dropShadow) {
        FormattedCharSequence sequence = text.getVisualOrderText();
        guiGraphics.drawString(font, sequence, x - font.width(sequence) / 2, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color, boolean dropShadow) {
        FormattedCharSequence sequence = text.getVisualOrderText();
        guiGraphics.drawString(font, sequence, x - (float)font.width(sequence) / 2.0f, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color, boolean dropShadow) {
        guiGraphics.drawString(font, text, x - font.width(text) / 2, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        guiGraphics.drawString(font, text, x - font.width(text) / 2, y, color, dropShadow);
    }

    public static boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public static MutableComponent illageriate(MutableComponent input, double percentage, long seed) {
        return ScreenUtils.stylizeWithReplacement(input, percentage, Style.EMPTY.withFont(ILLAGER_ALT_FONT), seed);
    }

    public static MutableComponent galactizate(MutableComponent input, double percentage, long seed) {
        return ScreenUtils.stylizeWithReplacement(input, percentage, Style.EMPTY.withFont(ALT_FONT), seed);
    }

    public static MutableComponent obfuscate(MutableComponent input, double percentage, long seed) {
        return ScreenUtils.stylize(input, percentage, Style.EMPTY.withObfuscated(Boolean.valueOf(true)), seed);
    }

    public static MutableComponent stylizeWithReplacement(String input, double percentage, Style style, long seed) {
        return ScreenUtils.stylizeWithReplacement(Component.literal((String)input), percentage, style, seed);
    }

    public static MutableComponent stylizeWithReplacement(MutableComponent input, double percentage, Style style, long seed) {
        RandomSource random = RandomSource.create((long)seed);
        String text = input.getString();
        List letterIndices = IntStream.range(0, text.length()).filter(i -> !Character.isSpaceChar(text.charAt(i))).boxed().collect(Collectors.toList());
        Collections.shuffle(letterIndices, new Random(seed));
        HashSet indicesToReplace = new HashSet(letterIndices.subList(0, Math.min((int)Math.round((double)letterIndices.size() * percentage), letterIndices.size())));
        List<Character> englishLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".chars().mapToObj(c -> Character.valueOf((char)c)).toList();
        return IntStream.range(0, text.length()).mapToObj(i -> {
            if (indicesToReplace.contains(i)) {
                return Component.literal((String)String.valueOf(englishLetters.get(random.nextInt(englishLetters.size())))).setStyle(style);
            }
            return Component.literal((String)String.valueOf(text.charAt(i))).setStyle(input.getStyle());
        }).collect(Component::empty, MutableComponent::append, MutableComponent::append);
    }

    public static MutableComponent randomizeAllCharacters(MutableComponent input, long seed) {
        RandomSource random = RandomSource.create((long)seed);
        String text = input.getString();
        List<Character> englishLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".chars().mapToObj(c -> Character.valueOf((char)c)).toList();
        return IntStream.range(0, text.length()).mapToObj(i -> {
            char c = text.charAt(i);
            char out = Character.isSpaceChar(c) ? c : ((Character)englishLetters.get(random.nextInt(englishLetters.size()))).charValue();
            return Component.literal((String)String.valueOf(out));
        }).collect(Component::empty, MutableComponent::append, MutableComponent::append);
    }

    public static MutableComponent stylize(MutableComponent input, double percentage, Style style, long seed) {
        RandomSource random = RandomSource.create((long)seed);
        String text = input.getString();
        int length = text.length();
        Set indices = IntStream.generate(() -> random.nextInt(length)).distinct().limit((int)((double)length * percentage)).boxed().collect(Collectors.toSet());
        return IntStream.range(0, length).mapToObj(index -> {
            MutableComponent component = Component.literal((String)String.valueOf(text.charAt(index))).setStyle(input.getStyle());
            if (indices.contains(index)) {
                component.setStyle(style.applyTo(component.getStyle()));
            }
            return component;
        }).collect(Component::empty, MutableComponent::append, MutableComponent::append);
    }
}

