/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.style.base.RelicStyle;
import it.hurts.sskirillss.relics.init.RelicsRelicStyles;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(modid="relics", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class TooltipBorderHandler {
    @SubscribeEvent
    public static void onTooltipDisplay(TooltipDisplayEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        GuiGraphics graphics = event.getGraphics();
        PoseStack poseStack = graphics.pose();
        int width = event.getWidth();
        int height = event.getHeight();
        int x = event.getX();
        int y = event.getY();
        String id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/tooltip/frame/" + id + "/frame.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.getInstance().getTextureManager().getTexture(texture).bind();
        int texWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int texHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        if (texHeight == 0 || texWidth == 0) {
            return;
        }
        int patternWidth = 160;
        int patternHeight = 64;
        int cornerWidth = 32;
        int cornerHeight = 32;
        int middleWidth = 96;
        int middleHeight = cornerHeight;
        poseStack.pushPose();
        RenderSystem.enableBlend();
        poseStack.translate(0.0, 0.0, 410.0);
        AnimationData animation = AnimationData.fromMcmeta(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/tooltip/frame/" + id + "/frame.png.mcmeta")));
        int frame = (Integer)animation.getFrameByTime(player.tickCount).getKey();
        int offset = patternHeight * frame;
        graphics.blit(texture, x - cornerWidth / 2 - 3, y - cornerHeight / 2 - 3, 0.0f, (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + width - cornerWidth / 2 + 3, y - cornerHeight / 2 - 3, (float)(patternWidth - cornerWidth), (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x - cornerWidth / 2 - 3, y + height - cornerHeight / 2 + 3, 0.0f, (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + width - cornerWidth / 2 + 3, y + height - cornerHeight / 2 + 3, (float)(patternWidth - cornerWidth), (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + (width - middleWidth) / 2, y - middleHeight + 1, (float)cornerWidth, (float)offset, middleWidth, middleHeight, texWidth, texHeight);
        graphics.blit(texture, x + (width - middleWidth) / 2, y + height - 1, (float)cornerWidth, (float)(middleHeight + offset), middleWidth, middleHeight, texWidth, texHeight);
        texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/tooltip/frame/" + id + "/star.png"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int xOff = 0;
        for (int i = 1; i < relic.calculateRelicQuality((LivingEntity)player, stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            float color = (float)(1.0 + Math.sin((float)(player.tickCount * i) * 0.05f) * (double)0.1f);
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            graphics.blit(texture, x + width / 2 - 14 + xOff, y - 10, (float)(isAliquot ? 0 : 3), 0.0f, isAliquot ? 3 : 2, 5, 5, 5);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            xOff += 3;
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        LocalPlayer player = Minecraft.getInstance().player;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        Optional<RelicStyle> optional = RelicsRelicStyles.getStyle(relic.getItem());
        if (optional.isEmpty()) {
            return;
        }
        RelicStyle style = optional.get();
        OctoColor topBorder = style.getTopTooltipBorderColor((LivingEntity)player, stack);
        OctoColor bottomBorder = style.getBottomTooltipBorderColor((LivingEntity)player, stack);
        if (topBorder != null) {
            event.setBorderStart(topBorder.getARGB());
        }
        if (bottomBorder != null) {
            event.setBorderEnd(bottomBorder.getARGB());
        }
        OctoColor topBackground = style.getTopTooltipBackgroundColor((LivingEntity)player, stack);
        OctoColor bottomBackground = style.getBottomTooltipBackgroundColor((LivingEntity)player, stack);
        if (topBackground != null) {
            event.setBackgroundStart(topBackground.getARGB());
        }
        if (bottomBackground != null) {
            event.setBackgroundEnd(bottomBackground.getARGB());
        }
    }
}

