/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.commands.arguments.AbilityArgument;
import it.hurts.sskirillss.relics.commands.arguments.AbilityStatArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityStatisticMetricArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicStatisticMetricArgument;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.command.EnumArgument;

public class RelicsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"relics").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"relic").then(Commands.literal((String)"maximize").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                source.sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            LevelingTemplate levelingTemplate = relic.getLevelingTemplate((LivingEntity)player, stack);
            relic.setRelicRank((LivingEntity)player, stack, levelingTemplate.getMaxRank());
            relic.setRelicLevel((LivingEntity)player, stack, relic.calculateRelicMaxLevel((LivingEntity)player, stack));
            relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().forEach((abilityId, abilityTemplate) -> {
                relic.setAbilityLevel((LivingEntity)player, stack, (String)abilityId, abilityTemplate.getInitialMaxLevel());
                relic.setLockUnlocks((LivingEntity)player, stack, (String)abilityId, relic.getMaxLockUnlocks());
                relic.setAbilityResearched((LivingEntity)player, stack, (String)abilityId, true);
                abilityTemplate.getStats().keySet().forEach(statId -> relic.setStatInitialQuality((LivingEntity)player, stack, (String)abilityId, (String)statId, relic.getStatMaxQuality((LivingEntity)player, stack, (String)abilityId, (String)statId)));
            });
            return 1;
        }))).then(Commands.literal((String)"minimize").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                source.sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            relic.setRelicRank((LivingEntity)player, stack, 0);
            relic.setRelicLevel((LivingEntity)player, stack, 0);
            relic.setRelicExperience((LivingEntity)player, stack, 0.0);
            relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().forEach((abilityId, abilityTemplate) -> {
                relic.setAbilityResearched((LivingEntity)player, stack, (String)abilityId, false);
                relic.setAbilityLevel((LivingEntity)player, stack, (String)abilityId, 0);
                relic.setResearchLinks((LivingEntity)player, stack, (String)abilityId, (Map<String, List<Integer>>)new HashMap<String, List<Integer>>());
                if (!relic.isEnoughLevel((LivingEntity)player, stack, (String)abilityId)) {
                    relic.setLockUnlocks((LivingEntity)player, stack, (String)abilityId, 0);
                }
                abilityTemplate.getStats().keySet().forEach(statId -> relic.setStatInitialQuality((LivingEntity)player, stack, (String)abilityId, (String)statId, 0));
            });
            return 1;
        }))).then(Commands.literal((String)"level").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            relic.setRelicLevel((LivingEntity)player, stack, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> level;
                case 1 -> relic.getRelicLevel((LivingEntity)player, stack) + level;
                case 2 -> relic.getRelicLevel((LivingEntity)player, stack) - level;
            });
            return 1;
        }))))).then(Commands.literal((String)"experience").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"experience", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            int experience = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"experience");
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            relic.setRelicExperience(null, stack, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> experience;
                case 1 -> relic.getRelicExperience((LivingEntity)player, stack) + (double)experience;
                case 2 -> relic.getRelicExperience((LivingEntity)player, stack) - (double)experience;
            });
            return 1;
        }))))).then(Commands.literal((String)"points").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            int points = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"points");
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            relic.setRelicLevelingPoints((LivingEntity)player, stack, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> points;
                case 1 -> relic.getRelicLevelingPoints((LivingEntity)player, stack) + points;
                case 2 -> relic.getRelicLevelingPoints((LivingEntity)player, stack) - points;
            });
            return 1;
        }))))).then(Commands.literal((String)"rank").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"rank", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            int rank = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"rank");
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            relic.setRelicRank((LivingEntity)player, stack, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> rank;
                case 1 -> relic.getRelicRank((LivingEntity)player, stack) + rank;
                case 2 -> relic.getRelicRank((LivingEntity)player, stack) - rank;
            });
            return 1;
        }))))).then(Commands.literal((String)"statistic").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"metric", (ArgumentType)RelicStatisticMetricArgument.relicStatisticMetric()).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> {
            String[] stringArray;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            String metric = RelicStatisticMetricArgument.getRelicStatisticMetric(ctx, "metric");
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            if (metric.equals("all")) {
                stringArray = relic.getRelicStatisticTemplate((LivingEntity)player, stack).getMetrics().keySet().toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = metric;
            }
            Stream.of(stringArray).forEach(metricEntry -> relic.setRelicMetricValue((LivingEntity)player, stack, (String)metricEntry, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> value;
                case 1 -> relic.getRelicMetricValue((LivingEntity)player, stack, (String)metricEntry) + value;
                case 2 -> relic.getRelicMetricValue((LivingEntity)player, stack, (String)metricEntry) - value;
            }));
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ability").then(Commands.literal((String)"level").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            String ability = AbilityArgument.getAbility(ctx, "ability");
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            (ability.equals("all") ? relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().keySet() : Set.of(ability)).forEach(entry -> relic.setAbilityLevel((LivingEntity)player, stack, (String)entry, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> level;
                case 1 -> relic.getAbilityLevel((LivingEntity)player, stack, (String)entry) + level;
                case 2 -> relic.getAbilityLevel((LivingEntity)player, stack, (String)entry) - level;
            }));
            return 1;
        })))))).then(Commands.literal((String)"statistic").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.argument((String)"metric", (ArgumentType)RelicAbilityStatisticMetricArgument.abilityStatisticMetric()).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> {
            String[] stringArray;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            String ability = AbilityArgument.getAbility(ctx, "ability");
            String metric = RelicAbilityStatisticMetricArgument.getAbilityStatisticMetric(ctx, "metric");
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            if (ability.equals("all")) {
                stringArray = relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().keySet().toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ability;
            }
            Stream.of(stringArray).forEach(abilityEntry -> (metric.equals("all") ? relic.getAbilityTemplate((LivingEntity)player, stack, (String)abilityEntry).getStats().keySet().stream() : Stream.of(metric)).forEach(metricEntry -> relic.setAbilityMetricValue((LivingEntity)player, stack, (String)abilityEntry, (String)metricEntry, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> value;
                case 1 -> relic.getAbilityMetricValue((LivingEntity)player, stack, (String)abilityEntry, (String)metricEntry) + value;
                case 2 -> relic.getAbilityMetricValue((LivingEntity)player, stack, (String)abilityEntry, (String)metricEntry) - value;
            })));
            return 1;
        }))))))).then(Commands.literal((String)"stat").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)AbilityStatArgument.abilityStat()).then(Commands.argument((String)"override", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> {
            String[] stringArray;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            String ability = AbilityArgument.getAbility(ctx, "ability");
            String stat = AbilityStatArgument.getAbilityStat(ctx, "stat");
            double override = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"override");
            if (ability.equals("all")) {
                stringArray = relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().keySet().toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ability;
            }
            Stream.of(stringArray).forEach(abilityEntry -> (stat.equals("all") ? relic.getAbilityTemplate((LivingEntity)player, stack, (String)abilityEntry).getStats().keySet().stream() : Stream.of(stat)).forEach(statEntry -> relic.setStatOverrideValue((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> override;
                case 1 -> relic.getOrCalculateStatValue((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry) + override;
                case 2 -> relic.getOrCalculateStatValue((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry) - override;
            })));
            return 1;
        }))))))).then(Commands.literal((String)"quality").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.argument((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)AbilityStatArgument.abilityStat()).then(Commands.argument((String)"quality", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            String[] stringArray;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            CommandAction action = (CommandAction)((Object)((Object)ctx.getArgument("action", CommandAction.class)));
            String ability = AbilityArgument.getAbility(ctx, "ability");
            String stat = AbilityStatArgument.getAbilityStat(ctx, "stat");
            int quality = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"quality");
            if (ability.equals("all")) {
                stringArray = relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().keySet().toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ability;
            }
            Stream.of(stringArray).forEach(abilityEntry -> (stat.equals("all") ? relic.getAbilityTemplate((LivingEntity)player, stack, (String)abilityEntry).getStats().keySet().stream() : Stream.of(stat)).forEach(statEntry -> relic.setStatInitialQuality((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry, switch (action.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> quality;
                case 1 -> relic.getStatInitialQuality((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry) + quality;
                case 2 -> relic.getStatInitialQuality((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry) - quality;
            })));
            return 1;
        }))))))).then(Commands.literal((String)"randomize").then(Commands.argument((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.argument((String)"stat", (ArgumentType)AbilityStatArgument.abilityStat()).executes(ctx -> {
            String[] stringArray;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            String ability = AbilityArgument.getAbility(ctx, "ability");
            String stat = AbilityStatArgument.getAbilityStat(ctx, "stat");
            if (ability.equals("all")) {
                stringArray = relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().keySet().toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ability;
            }
            Stream.of(stringArray).forEach(abilityEntry -> (stat.equals("all") ? relic.getAbilityTemplate((LivingEntity)player, stack, (String)abilityEntry).getStats().keySet().stream() : Stream.of(stat)).forEach(statEntry -> relic.randomizeStat((LivingEntity)player, stack, (String)abilityEntry, (String)statEntry)));
            return 1;
        }))))));
    }

    public static enum CommandAction {
        SET,
        ADD,
        TAKE;

    }
}

