/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AbilityStatArgument
implements ArgumentType<String> {
    public static AbilityStatArgument abilityStat() {
        return new AbilityStatArgument();
    }

    public static String getAbilityStat(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof ClientSuggestionProvider ? this.constructSuggestions(context, builder) : Suggestions.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <S> CompletableFuture<Suggestions> constructSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = player.getMainHandItem().getItem()) instanceof IRelicItem)) {
            return Suggestions.empty();
        }
        IRelicItem relic = (IRelicItem)item;
        String ability = StringArgumentType.getString(context, (String)"ability");
        ArrayList<String> result = new ArrayList<String>();
        if (ability.equals("all")) {
            for (AbilityTemplate abilityEntry : relic.getRelicTemplate((LivingEntity)player, player.getMainHandItem()).getAbilities().getAbilities().values()) {
                result.addAll(abilityEntry.getStats().keySet());
            }
        } else {
            AbilityTemplate data = relic.getAbilityTemplate((LivingEntity)player, player.getMainHandItem(), ability);
            if (data == null) {
                return Suggestions.empty();
            }
            result.addAll(data.getStats().keySet());
        }
        result.add("all");
        return SharedSuggestionProvider.suggest(result, (SuggestionsBuilder)builder);
    }
}

