/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RelicAbilityStatisticMetricArgument
implements ArgumentType<String> {
    public static RelicAbilityStatisticMetricArgument abilityStatisticMetric() {
        return new RelicAbilityStatisticMetricArgument();
    }

    public static String getAbilityStatisticMetric(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof ClientSuggestionProvider ? this.constructSuggestions(context, builder) : Suggestions.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <S> CompletableFuture<Suggestions> constructSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return Suggestions.empty();
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return Suggestions.empty();
        }
        IRelicItem relic = (IRelicItem)item;
        String ability = StringArgumentType.getString(context, (String)"ability");
        ArrayList<String> result = new ArrayList<String>();
        if (ability.equals("all")) {
            for (AbilityTemplate abilityEntry : relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().values()) {
                result.addAll(abilityEntry.getStatistic().getMetrics().keySet());
            }
        } else {
            result.addAll(relic.getAbilityStatisticTemplate((LivingEntity)player, stack, ability).getMetrics().keySet());
        }
        result.add("all");
        return SharedSuggestionProvider.suggest(result, (SuggestionsBuilder)builder);
    }
}

