/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.module.config.annotation.Prop;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.config.data.StatConfigData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AbilityConfigData {
    @Prop(comment="Number of leveling points needed to increase the ability level")
    private int requiredPoints;
    @Prop(comment="Relic level at which the ability becomes unlocked")
    private int requiredLevel;
    @Prop(comment="Highest level to which the ability can be upgraded")
    private int maxLevel;
    private Map<String, StatConfigData> stats = new LinkedHashMap<String, StatConfigData>();

    public AbilityTemplate toData(IRelicItem relic, String ability) {
        AbilityTemplate template = relic.getDefaultAbilityTemplate(ability);
        return template.toBuilder().requiredPoints(this.requiredPoints).requiredLevel(this.requiredLevel).initialMaxLevel(this.maxLevel).stats(template.getStats().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.stats.get(entry.getKey()).toData(relic, ability, (String)entry.getKey()), (o1, o2) -> o1, LinkedHashMap::new))).build();
    }

    @Generated
    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    @Generated
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public Map<String, StatConfigData> getStats() {
        return this.stats;
    }

    @Generated
    public void setRequiredPoints(int requiredPoints) {
        this.requiredPoints = requiredPoints;
    }

    @Generated
    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    @Generated
    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Generated
    public void setStats(Map<String, StatConfigData> stats) {
        this.stats = stats;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbilityConfigData)) {
            return false;
        }
        AbilityConfigData other = (AbilityConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequiredPoints() != other.getRequiredPoints()) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        Map<String, StatConfigData> this$stats = this.getStats();
        Map<String, StatConfigData> other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbilityConfigData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequiredPoints();
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + this.getMaxLevel();
        Map<String, StatConfigData> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbilityConfigData(requiredPoints=" + this.getRequiredPoints() + ", requiredLevel=" + this.getRequiredLevel() + ", maxLevel=" + this.getMaxLevel() + ", stats=" + String.valueOf(this.getStats()) + ")";
    }

    @Generated
    public AbilityConfigData() {
    }

    @Generated
    public AbilityConfigData(int requiredPoints, int requiredLevel, int maxLevel, Map<String, StatConfigData> stats) {
        this.requiredPoints = requiredPoints;
        this.requiredLevel = requiredLevel;
        this.maxLevel = maxLevel;
        this.stats = stats;
    }
}

