/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.module.config.annotation.IgnoreProp;
import it.hurts.octostudios.octolib.module.config.impl.OctoConfig;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.config.data.AbilitiesConfigData;
import it.hurts.sskirillss.relics.config.data.LevelingConfigData;
import it.hurts.sskirillss.relics.config.data.LootConfigData;
import it.hurts.sskirillss.relics.level.RelicLootModifier;
import lombok.Generated;

public class RelicConfigData
implements OctoConfig {
    @IgnoreProp
    private IRelicItem relic;
    private AbilitiesConfigData abilitiesData;
    private LevelingConfigData levelingData;
    private LootConfigData lootData;

    public RelicConfigData(IRelicItem relic) {
        this.relic = relic;
        this.setAbilitiesData(relic.getDefaultAbilitiesTemplate().toConfigData());
        this.setLevelingData(relic.getDefaultLevelingTemplate().toConfigData());
        this.setLootData(relic.getDefaultLootTemplate().toConfigData());
    }

    public RelicTemplate toData(IRelicItem relic) {
        return relic.getDefaultRelicTemplate().toBuilder().abilities(this.abilitiesData.toData(relic)).leveling(this.levelingData.toData(relic)).loot(this.lootData.toData(relic)).build();
    }

    public void onLoadObject(Object object) {
        this.relic.setRelicTemplate(((RelicConfigData)object).toData(this.relic));
        RelicLootModifier.processRelicCache(this.relic);
    }

    @Generated
    public IRelicItem getRelic() {
        return this.relic;
    }

    @Generated
    public AbilitiesConfigData getAbilitiesData() {
        return this.abilitiesData;
    }

    @Generated
    public LevelingConfigData getLevelingData() {
        return this.levelingData;
    }

    @Generated
    public LootConfigData getLootData() {
        return this.lootData;
    }

    @Generated
    public void setRelic(IRelicItem relic) {
        this.relic = relic;
    }

    @Generated
    public void setAbilitiesData(AbilitiesConfigData abilitiesData) {
        this.abilitiesData = abilitiesData;
    }

    @Generated
    public void setLevelingData(LevelingConfigData levelingData) {
        this.levelingData = levelingData;
    }

    @Generated
    public void setLootData(LootConfigData lootData) {
        this.lootData = lootData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicConfigData)) {
            return false;
        }
        RelicConfigData other = (RelicConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IRelicItem this$relic = this.getRelic();
        IRelicItem other$relic = other.getRelic();
        if (this$relic == null ? other$relic != null : !this$relic.equals(other$relic)) {
            return false;
        }
        AbilitiesConfigData this$abilitiesData = this.getAbilitiesData();
        AbilitiesConfigData other$abilitiesData = other.getAbilitiesData();
        if (this$abilitiesData == null ? other$abilitiesData != null : !((Object)this$abilitiesData).equals(other$abilitiesData)) {
            return false;
        }
        LevelingConfigData this$levelingData = this.getLevelingData();
        LevelingConfigData other$levelingData = other.getLevelingData();
        if (this$levelingData == null ? other$levelingData != null : !((Object)this$levelingData).equals(other$levelingData)) {
            return false;
        }
        LootConfigData this$lootData = this.getLootData();
        LootConfigData other$lootData = other.getLootData();
        return !(this$lootData == null ? other$lootData != null : !((Object)this$lootData).equals(other$lootData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelicConfigData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IRelicItem $relic = this.getRelic();
        result = result * 59 + ($relic == null ? 43 : $relic.hashCode());
        AbilitiesConfigData $abilitiesData = this.getAbilitiesData();
        result = result * 59 + ($abilitiesData == null ? 43 : ((Object)$abilitiesData).hashCode());
        LevelingConfigData $levelingData = this.getLevelingData();
        result = result * 59 + ($levelingData == null ? 43 : ((Object)$levelingData).hashCode());
        LootConfigData $lootData = this.getLootData();
        result = result * 59 + ($lootData == null ? 43 : ((Object)$lootData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelicConfigData(relic=" + String.valueOf(this.getRelic()) + ", abilitiesData=" + String.valueOf(this.getAbilitiesData()) + ", levelingData=" + String.valueOf(this.getLevelingData()) + ", lootData=" + String.valueOf(this.getLootData()) + ")";
    }

    @Generated
    public RelicConfigData() {
    }
}

