/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.items.relics.head.PiglinMaskItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;

public class GoldenToothEntity
extends Entity {
    private static final EntityDataAccessor<Integer> STACKS = SynchedEntityData.defineId(GoldenToothEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GoldenToothEntity(EntityType<? extends GoldenToothEntity> type, Level level) {
        super(type, level);
    }

    public int getStacks() {
        return (Integer)this.getEntityData().get(STACKS);
    }

    public void setStacks(int experience) {
        this.getEntityData().set(STACKS, (Object)experience);
    }

    private List<ItemStack> getSuitableRelics(LivingEntity entity) {
        return EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.PIGLIN_MASK.get());
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount >= 15) {
            for (GoldenToothEntity tooth : this.level().getEntitiesOfClass(GoldenToothEntity.class, this.getBoundingBox())) {
                if (tooth.getUUID().equals(this.getUUID()) || tooth.isRemoved()) continue;
                this.setStacks(this.getStacks() + tooth.getStacks());
                tooth.discard();
            }
            double maxDistance = 16.0;
            Player player = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), maxDistance, entity -> {
                Player entry = (Player)entity;
                return !entry.isSpectator() && !this.getSuitableRelics((LivingEntity)entry).isEmpty();
            });
            if (player != null) {
                this.setDeltaMovement(this.getDeltaMovement().add(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0).subtract(this.position()).normalize().scale((maxDistance - this.position().distanceTo(player.position())) / (maxDistance * 10.0))));
                if (this.position().distanceTo(player.position()) <= (double)(player.getBbWidth() * 1.25f)) {
                    List<ItemStack> suitable = this.getSuitableRelics((LivingEntity)player);
                    for (ItemStack stack : suitable) {
                        PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
                        if (relic.getStacks(stack) < PiglinMaskItem.getMaxStacks()) {
                            relic.addStacks(stack, this.getStacks());
                            relic.setDuration((LivingEntity)player, stack, relic.getMaxDuration((LivingEntity)player, stack));
                            relic.addAbilityMetricValue((LivingEntity)player, stack, "looting", "teeth_picked_up", this.getStacks());
                            relic.addRelicExperience((LivingEntity)player, stack, "looting", "stack", this.getStacks());
                        }
                        player.addItem(new ItemStack((ItemLike)RelicsItems.GOLDEN_TOOTH.get(), this.getStacks()));
                        this.discard();
                        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value(), SoundSource.MASTER, 0.5f, 1.25f + this.level().getRandom().nextFloat() * 0.75f);
                    }
                }
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float friction = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            friction = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)friction, 0.98, (double)friction));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (this.tickCount >= 1000) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setStacks(tag.getInt("stacks"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("stacks", this.getStacks());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STACKS, (Object)0);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999f);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isAttackable() {
        return false;
    }

    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (STACKS.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<GoldenToothEntity> {
        public TrailProvider(GoldenToothEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((GoldenToothEntity)this.entity).getPosition(partialTicks).add(0.0, (double)0.45f, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((GoldenToothEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((GoldenToothEntity)this.entity).tickCount > 1;
        }

        public int getTrailMaxLength() {
            return 3;
        }

        public int getTrailFadeInColor() {
            return -256;
        }

        public int getTrailFadeOutColor() {
            return 0xFF0000;
        }

        public double getTrailScale() {
            return 0.1f;
        }
    }
}

