/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.necklace.ReflectiveNecklaceItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class ReflectiveOrbEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> TARGETED = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Vector3f> TARGET = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PIERCINGS = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> STUN = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(ReflectiveOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;
    private boolean bounced = false;
    private boolean takeBounces = false;
    private boolean spawnBounceParticles = false;
    private List<String> impactedEntities = new ArrayList<String>();
    private static final int ARC_DURATION = 10;

    public void setTarget(Vec3 target) {
        this.getEntityData().set(TARGET, (Object)target.toVector3f());
    }

    public Vec3 getTarget() {
        Vector3f target = (Vector3f)this.getEntityData().get(TARGET);
        return new Vec3((double)target.x(), (double)target.y(), (double)target.z());
    }

    public void setLifetime(int lifetime) {
        this.getEntityData().set(LIFETIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.getEntityData().get(LIFETIME);
    }

    public void setTargeted(boolean targeted) {
        this.getEntityData().set(TARGETED, (Object)targeted);
    }

    public boolean isTargeted() {
        return (Boolean)this.getEntityData().get(TARGETED);
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setPiercings(int remainingPierces) {
        this.getEntityData().set(PIERCINGS, (Object)remainingPierces);
    }

    public int getPiercings() {
        return (Integer)this.getEntityData().get(PIERCINGS);
    }

    public void setStun(float stun) {
        this.getEntityData().set(STUN, (Object)Float.valueOf(stun));
    }

    public float getStun() {
        return ((Float)this.getEntityData().get(STUN)).floatValue();
    }

    public void setBounces(int bounces) {
        this.getEntityData().set(BOUNCES, (Object)bounces);
    }

    public int getBounces() {
        return (Integer)this.getEntityData().get(BOUNCES);
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public ReflectiveOrbEntity(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
    }

    public void tick() {
        Vec3 cachedMotion = this.getDeltaMovement();
        super.tick();
        this.noPhysics = this.tickCount <= 10;
        Level level = this.level();
        boolean isTargeted = this.isTargeted();
        Vec3 target = this.getTarget();
        Vec3 position = this.position();
        Vec3 semiTarget = this.getOwner() == null ? target : this.getOwner().position();
        int maxDistance = 16;
        Vec3 normal = position.subtract(semiTarget).normalize();
        Vec3 origin = semiTarget.add(normal.scale((double)maxDistance));
        if (this.tickCount >= this.getLifetime() + (isTargeted ? 100 : 0)) {
            this.discard();
            return;
        }
        if (target.equals((Object)Vec3.ZERO)) {
            if (this.tickCount < 10) {
                double damp = 1.0 - (double)this.tickCount / 10.0;
                this.setDeltaMovement(new Vec3(cachedMotion.x() * damp, 0.25 + (double)this.random.nextFloat() * 0.25, cachedMotion.z() * damp));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f));
            }
        } else if (!isTargeted) {
            this.setTargeted(true);
            this.setDeltaMovement(target.subtract(position).normalize().scale(1.5));
        } else {
            if (!this.bounced) {
                this.setDeltaMovement(cachedMotion);
            }
            if (position.distanceTo(semiTarget) >= (double)maxDistance && this.bounce(normal, origin)) {
                this.spawnBounceParticles = true;
            }
        }
        if (level.isClientSide()) {
            RandomSource random = level.getRandom();
            level.addParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + random.nextInt(50), 150 + random.nextInt(50), 0) : new Color(50 + random.nextInt(100), random.nextInt(100), 255), 0.1f + random.nextFloat() * 0.15f, 15, 0.9f), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), (double)(MathUtils.randomFloat(random) * 0.05f), (double)(MathUtils.randomFloat(random) * 0.05f), (double)(MathUtils.randomFloat(random) * 0.05f));
        }
        if (this.takeBounces && position.distanceTo(semiTarget) < (double)maxDistance) {
            this.setBounces(this.getBounces() - 1);
            this.takeBounces = false;
            Item item = this.stack.getItem();
            if (item instanceof ReflectiveNecklaceItem) {
                ReflectiveNecklaceItem relic = (ReflectiveNecklaceItem)item;
                item = this.getOwner();
                if (item instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)item;
                    relic.addAbilityMetricValue(owner, this.stack, "reflection", "total_bounces", 1.0);
                }
            }
            if (this.spawnBounceParticles) {
                Vec3 up = Math.abs(normal.y) < 0.99 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
                Vec3 axis1 = normal.cross(up).normalize();
                Vec3 axis2 = normal.cross(axis1).normalize();
                int segments = 6;
                double radius = 1.0;
                Vec3[] directions = new Vec3[segments];
                for (int i = 0; i < segments; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)segments;
                    directions[i] = axis1.scale(Math.cos(angle) * radius).add(axis2.scale(Math.sin(angle) * radius));
                }
                double fillStep = 0.25;
                float shatterSpeed = 0.075f;
                for (int i = 0; i < segments; ++i) {
                    Vec3 edge1 = directions[i];
                    Vec3 edge2 = directions[(i + 1) % segments];
                    for (double t = 0.0; t <= 1.0; t += fillStep) {
                        for (double u = 0.0; u <= 1.0 - t; u += fillStep) {
                            Vec3 point = origin.add(edge1.scale(t)).add(edge2.scale(u));
                            Vec3 shardDir = point.subtract(origin).normalize();
                            float vx = (float)(shardDir.x * (double)shatterSpeed);
                            float vy = (float)(shardDir.y * (double)shatterSpeed);
                            float vz = (float)(shardDir.z * (double)shatterSpeed);
                            this.level().addParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : new Color(50 + this.random.nextInt(100), this.random.nextInt(100), 255), 0.35f, 40, 0.9f), true, point.x, point.y, point.z, (double)vx, (double)vy, (double)vz);
                        }
                    }
                }
                this.spawnBounceParticles = false;
            }
        }
        this.bounced = false;
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos pos = result.getBlockPos();
        Level level = this.level();
        if (level.isClientSide() || this.noPhysics || this.bounced || !level.getBlockState(pos).blocksMotion()) {
            return;
        }
        Vec3 faceNormal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal()).normalize();
        Vec3 hitLocation = result.getLocation();
        this.bounce(faceNormal, hitLocation);
    }

    public boolean bounce(Vec3 normal, Vec3 origin) {
        int bounces = this.getBounces();
        if (bounces <= 0) {
            this.discard();
            return false;
        }
        Vec3 motion = this.getDeltaMovement();
        Vec3 reflected = motion.subtract(normal.scale(2.0 * motion.dot(normal)));
        double halfWidth = (double)this.getBbWidth() * 0.5;
        double halfHeight = (double)this.getBbHeight() * 0.5;
        double eps = 0.001;
        double pushDist = Math.abs(normal.x) * halfWidth + Math.abs(normal.y) * halfHeight + Math.abs(normal.z) * halfWidth + eps;
        Vec3 newPos = origin.add(normal.scale(pushDist));
        this.setPos(newPos.x, newPos.y, newPos.z);
        this.setDeltaMovement(reflected);
        this.bounced = true;
        this.takeBounces = true;
        return true;
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity owner;
        LivingEntity entity;
        block10: {
            block9: {
                Entity entity2;
                if (this.tickCount < 10 || !((entity2 = result.getEntity()) instanceof LivingEntity) || this.impactedEntities.contains((entity = (LivingEntity)entity2).getStringUUID()) || !((entity2 = this.getOwner()) instanceof LivingEntity)) break block9;
                owner = (LivingEntity)entity2;
                if (!entity.getStringUUID().equals(owner.getStringUUID())) break block10;
            }
            return;
        }
        entity.invulnerableTime = 0;
        if (entity.hurt(this.level().damageSources().thrown((Entity)owner, (Entity)this), this.getDamage())) {
            Item item;
            float stun = this.getStun();
            if (stun > 0.0f) {
                entity.addEffect(new MobEffectInstance(RelicsMobEffects.STUN, (int)(stun * 20.0f), 0, false, false));
            }
            if ((item = this.stack.getItem()) instanceof ReflectiveNecklaceItem) {
                ReflectiveNecklaceItem relic = (ReflectiveNecklaceItem)item;
                relic.addAbilityMetricValue(entity, this.stack, "reflection", "total_damage", this.getDamage());
                if (stun > 0.0f) {
                    relic.addAbilityMetricValue(entity, this.stack, "reflection", "total_stun", stun);
                }
                relic.addRelicExperience(entity, this.stack, "reflection", "impact", 1.0);
            }
        }
        this.impactedEntities.add(entity.getStringUUID());
        int remainingPierces = this.getPiercings();
        if (remainingPierces <= 0) {
            this.discard();
        } else {
            this.setPiercings(remainingPierces - 1);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide()) {
            return false;
        }
        Entity owner = this.getOwner();
        Entity attacker = source.getEntity();
        if (owner != null && attacker != null && owner.getStringUUID().equals(attacker.getStringUUID())) {
            return false;
        }
        this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        this.discard();
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.define(TARGETED, (Object)false);
        builder.define(TARGET, (Object)Vec3.ZERO.toVector3f());
        builder.define(LIFETIME, (Object)0);
        builder.define(PIERCINGS, (Object)0);
        builder.define(STUN, (Object)Float.valueOf(0.0f));
        builder.define(BOUNCES, (Object)0);
        builder.define(FLAWLESS, (Object)false);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage());
        tag.putBoolean("targeted", this.isTargeted());
        tag.putInt("lifetime", this.getLifetime());
        tag.putInt("piercings", this.getPiercings());
        tag.putInt("bounces", this.getBounces());
        tag.putFloat("stun", this.getStun());
        tag.putBoolean("flawless", this.isFlawless());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(tag.getFloat("damage"));
        this.setTargeted(tag.getBoolean("targeted"));
        this.setLifetime(tag.getInt("lifetime"));
        this.setPiercings(tag.getInt("piercings"));
        this.setBounces(tag.getInt("bounces"));
        this.setStun(tag.getFloat("stun"));
        this.setFlawless(tag.getBoolean("flawless"));
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<ReflectiveOrbEntity> {
        public TrailProvider(ReflectiveOrbEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((ReflectiveOrbEntity)this.entity).getPosition(partialTicks).add(0.0, (double)((ReflectiveOrbEntity)this.entity).getBbHeight() / 2.0, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((ReflectiveOrbEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((ReflectiveOrbEntity)this.entity).tickCount > 0;
        }

        public int getTrailMaxLength() {
            return 7;
        }

        public int getTrailFadeInColor() {
            return ((ReflectiveOrbEntity)this.entity).isFlawless() ? -256 : -8388353;
        }

        public int getTrailFadeOutColor() {
            return ((ReflectiveOrbEntity)this.entity).isFlawless() ? 0xFF0000 : -2147483393;
        }

        public double getTrailScale() {
            return 0.15f;
        }
    }
}

