/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ShockwaveBlockEntity
extends Projectile {
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(ShockwaveBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<BlockPos> CENTER = SynchedEntityData.defineId(ShockwaveBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ShockwaveBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> STUN = SynchedEntityData.defineId(ShockwaveBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> KNOCKBACK = SynchedEntityData.defineId(ShockwaveBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private ItemStack stack = ItemStack.EMPTY;

    public BlockState getBlockState() {
        return (BlockState)this.getEntityData().get(BLOCK_STATE);
    }

    public void setBlockState(BlockState state) {
        this.getEntityData().set(BLOCK_STATE, (Object)state);
    }

    public BlockPos getCenter() {
        return (BlockPos)this.getEntityData().get(CENTER);
    }

    public void setCenter(BlockPos center) {
        this.getEntityData().set(CENTER, (Object)center);
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getStun() {
        return (Integer)this.getEntityData().get(STUN);
    }

    public void setStun(int stun) {
        this.getEntityData().set(STUN, (Object)stun);
    }

    public float getKnockback() {
        return ((Float)this.getEntityData().get(KNOCKBACK)).floatValue();
    }

    public void setKnockback(float knockback) {
        this.getEntityData().set(KNOCKBACK, (Object)Float.valueOf(knockback));
    }

    public ShockwaveBlockEntity(EntityType<? extends ShockwaveBlockEntity> pEntityType, Level level) {
        super(pEntityType, level);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.075, 0.0));
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.tickCount >= 20) {
            this.discard();
        }
        this.processTargets();
    }

    public void processTargets() {
        Level level = this.level();
        Vec3 center = this.getCenter().getCenter();
        Entity owner = this.getOwner();
        for (Entity entity2 : level.getEntitiesOfClass(Entity.class, this.getBoundingBox(), entity -> !(entity instanceof ShockwaveBlockEntity) && (owner == null || !owner.getStringUUID().equals(entity.getStringUUID())))) {
            int stun;
            Vec3 motion = entity2.position().add(0.0, 1.0, 0.0).subtract(center).normalize().scale((double)this.getKnockback());
            entity2.setDeltaMovement(motion);
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            float damage = this.getDamage();
            if (!livingEntity.hurt(level.damageSources().explosion(owner, (Entity)this), damage) || (stun = this.getStun()) <= 0) continue;
            livingEntity.addEffect(new MobEffectInstance(RelicsMobEffects.STUN, stun, 0, false, false));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
        builder.define(CENTER, (Object)BlockPos.ZERO);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(STUN, (Object)0);
        builder.define(KNOCKBACK, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.getCommandSenderWorld().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("block_state")));
        this.setCenter(NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO));
        this.setDamage(tag.getFloat("damage"));
        this.setStun(tag.getInt("stun"));
        this.setKnockback(tag.getFloat("knockback"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.getCenter()));
        tag.putFloat("damage", this.getDamage());
        tag.putInt("stun", this.getStun());
        tag.putFloat("knockback", this.getKnockback());
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

