/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.entities.LeavesBlockEntity;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.curios.api.SlotContext;

public class LeafyMantleItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("camouflage").rankModifier(3, "absorption").rankModifier(5, "disappearance").stat(StatTemplate.builder("heal").initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.6279).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("absorption").initialValue(1.0, 3.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1619).formatValue(value -> (int)MathUtils.round(value, 0)).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("hide_duration").formatValue(value -> MathUtils.formatTime(value.intValue())).build()).metric(AbilityMetricTemplate.builder("heal_amount").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("hiding").build()).source(ExperienceSourceTemplate.builder("healing").build()).build()).research(ResearchTemplate.builder().star(0, 8, 15).star(1, 14, 15).star(2, 2, 17).star(3, 20, 17).star(4, 2, 22).star(5, 11, 22).star(6, 20, 22).star(7, 2, 27).star(8, 20, 27).link(5, 2).link(5, 3).link(5, 4).link(5, 6).link(5, 7).link(5, 8).link(0, 1).build()).build()).ability(AbilityTemplate.builder("revival").requiredLevel(5).rankModifier(1, "piercing").stat(StatTemplate.builder("radius").initialValue(5.0, 10.0).upgradeModifier(RelicsScalingModels.EXPONENTIAL.get(), 0.0265).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("heal").initialValue(0.5, 1.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 1.1162).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("damage").initialValue(0.5, 1.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 1.1162).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("paralysis").initialValue(0.5, 1.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 1.1162).formatValue(value -> MathUtils.round(value, 1)).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("leaves_consumed").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("damage_negated").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("damage_dealt").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("piercing", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("paralysis_duration").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("piercing", VisibilityState.OBFUSCATED).build()).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("consuming_leaves").build()).source(ExperienceSourceTemplate.builder("leaves_impact").rankModifierVisibilityState("piercing", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 13, 5).star(1, 2, 14).star(2, 11, 17).star(3, 20, 19).star(4, 8, 28).link(2, 0).link(2, 4).link(2, 1).link(2, 3).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(200.0).build()).build();
    }

    public boolean isHiding(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RelicsDataComponents.LEAFY_MANTLE_HIDING, (Object)false);
    }

    public void setHiding(ItemStack stack, boolean hiding) {
        stack.set(RelicsDataComponents.LEAFY_MANTLE_HIDING, (Object)hiding);
    }

    public int getCurrentProgress(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.LEAFY_MANTLE_PROGRESS, (Object)0);
    }

    public void setCurrentProgress(ItemStack stack, int progress) {
        stack.set(RelicsDataComponents.LEAFY_MANTLE_PROGRESS, (Object)Math.clamp((long)progress, 0, this.getMaxProgress()));
    }

    public void addCurrentProgress(ItemStack stack, int progress) {
        this.setCurrentProgress(stack, this.getCurrentProgress(stack) + progress);
    }

    public int getMaxProgress() {
        return 10;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = livingEntity;
        Level level = entity.getCommandSenderWorld();
        int progress = this.getCurrentProgress(stack);
        boolean hiding = this.isHiding(stack);
        boolean inLeaves = BlockPos.betweenClosedStream((AABB)entity.getBoundingBox()).anyMatch(pos -> level.getBlockState(pos).is(BlockTags.LEAVES));
        if (inLeaves) {
            if (!hiding) {
                this.setHiding(stack, true);
            }
            if (progress < this.getMaxProgress()) {
                this.addCurrentProgress(stack, 1);
            }
            if (this.isAbilityRankModifierUnlocked(entity, stack, "camouflage", "disappearance")) {
                entity.addEffect(new MobEffectInstance(RelicsMobEffects.VANISHING, 5, 0, false, false));
            }
            if (entity.tickCount % 20 == 0) {
                if (entity.getHealth() < entity.getMaxHealth()) {
                    float heal = (float)Math.min(this.getStatValue(entity, stack, "camouflage", "heal"), (double)(entity.getMaxHealth() - entity.getHealth()));
                    entity.heal(heal);
                    if (!level.isClientSide()) {
                        this.addAbilityMetricValue(entity, stack, "camouflage", "heal_amount", heal);
                        this.addRelicExperience(entity, stack, "camouflage", "healing", heal);
                    }
                }
                if (!level.isClientSide()) {
                    this.addRelicExperience(entity, stack, "camouflage", "hiding", 1.0);
                    this.addAbilityMetricValue(entity, stack, "camouflage", "hide_duration", 1.0);
                }
            }
            if (level.isClientSide() && entity instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)entity;
                if (player.input.jumping) {
                    Vec3 motion = player.getDeltaMovement();
                    player.setDeltaMovement(motion.x(), 0.25, motion.z());
                }
            }
        } else {
            if (hiding) {
                this.setHiding(stack, false);
            }
            if (progress > 0) {
                this.addCurrentProgress(stack, -1);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, (Holder<Attribute>)Attributes.MAX_ABSORPTION, AttributeModifier.Operation.ADD_VALUE, CommonEvents.ATTRIBUTE);
    }

    @EventBusSubscriber
    public static class CommonEvents {
        public static final ResourceLocation ATTRIBUTE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"leafy_mantle/absorption");

        @SubscribeEvent
        public static void onLivingTick(EntityTickEvent.Post event) {
            LivingEntity entity;
            Entity entity2 = event.getEntity();
            if (!(entity2 instanceof LivingEntity) || (entity = (LivingEntity)entity2).level().isClientSide()) {
                return;
            }
            float total = 0.0f;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.LEAFY_MANTLE.get())) {
                LeafyMantleItem relic = (LeafyMantleItem)stack.getItem();
                if (!relic.isHiding(stack) || !relic.canPlayerUseAbility(entity, stack, "camouflage") || !relic.isAbilityRankModifierUnlocked(entity, stack, "camouflage", "absorption")) continue;
                total += (float)relic.getStatValue(entity, stack, "camouflage", "absorption");
            }
            float current = entity.getAbsorptionAmount();
            float cap = Math.max(current, total);
            if (cap > 0.0f) {
                EntityUtils.resetAttribute(entity, (Holder<Attribute>)Attributes.MAX_ABSORPTION, cap, AttributeModifier.Operation.ADD_VALUE, ATTRIBUTE);
                if (current < total) {
                    entity.setAbsorptionAmount(total);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
            if (!event.getSource().is(DamageTypeTags.IS_FALL)) {
                return;
            }
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.LEAFY_MANTLE.get())) {
                LeafyMantleItem relic = (LeafyMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "camouflage") || !level.getBlockState(entity.getBlockPosBelowThatAffectsMyMovement()).is(BlockTags.LEAVES)) continue;
                event.setCanceled(true);
                break;
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent.Pre event) {
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            RandomSource random = level.getRandom();
            float damage = event.getNewDamage();
            float health = entity.getHealth();
            float absorption = entity.getAbsorptionAmount();
            if (damage < health) {
                return;
            }
            float damageToThreshold = health - 0.1f;
            float remaining = damage - damageToThreshold;
            float diff = absorption - remaining;
            if (diff > 0.0f) {
                return;
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.LEAFY_MANTLE.get())) {
                LeafyMantleItem relic = (LeafyMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "revival")) continue;
                if (diff > 0.0f) break;
                if (!level.isClientSide()) {
                    relic.addAbilityMetricValue(entity, stack, "revival", "damage_negated", Math.abs(diff));
                }
                int radius = (int)Math.ceil(relic.getStatValue(entity, stack, "revival", "radius"));
                float heal = (float)relic.getStatValue(entity, stack, "revival", "heal");
                BlockPos center = entity.blockPosition();
                List<BlockPos> positions = IntStream.rangeClosed(-radius, radius).boxed().flatMap(dx -> IntStream.rangeClosed(-radius, radius).boxed().flatMap(dy -> IntStream.rangeClosed(-radius, radius).mapToObj(dz -> new BlockPos(center.getX() + dx, center.getY() + dy, center.getZ() + dz)))).filter(pos -> level.getBlockState(pos).is(BlockTags.LEAVES)).sorted(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)center))).toList();
                float potential = (float)positions.size() * heal;
                if (potential + diff < 0.0f) continue;
                int blocks = 0;
                for (BlockPos pos2 : positions) {
                    ServerScheduler.schedule(blocks + random.nextInt(10), () -> {
                        LeavesBlockEntity leaves = new LeavesBlockEntity((EntityType<? extends LeavesBlockEntity>)((EntityType)RelicsEntities.LEAVES_BLOCK.get()), level);
                        Vec3 posVec = new Vec3((double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5);
                        Vec3 toPlayer = entity.position().subtract(posVec).normalize();
                        Vec3 randomVec = new Vec3((double)MathUtils.randomFloat(random), (double)MathUtils.randomFloat(random), (double)MathUtils.randomFloat(random));
                        Vec3 perpendicular = randomVec.subtract(toPlayer.scale(randomVec.dot(toPlayer))).normalize().scale(0.5 + random.nextDouble() * 0.5);
                        leaves.setParalysis((float)relic.getStatValue(entity, stack, "revival", "paralysis"));
                        leaves.setDeltaMovement(perpendicular.scale((double)(0.5f + random.nextFloat())));
                        leaves.setFlawless(relic.isRelicFlawless(entity, stack));
                        leaves.setPos(posVec.x(), posVec.y(), posVec.z());
                        leaves.setBlockState(level.getBlockState(pos2));
                        leaves.setTarget(entity);
                        leaves.setOwner((Entity)entity);
                        leaves.setDamage(heal);
                        leaves.setStack(stack);
                        level.addFreshEntity((Entity)leaves);
                        level.destroyBlock(pos2, false);
                        if (!level.isClientSide()) {
                            relic.addAbilityMetricValue(entity, stack, "revival", "leaves_consumed", 1.0);
                            relic.addRelicExperience(entity, stack, "revival", "consuming_leaves", 1.0);
                        }
                    });
                    ++blocks;
                    if (!((diff += heal) >= 0.0f)) continue;
                    break;
                }
                if (blocks <= 0) continue;
                event.setNewDamage(damageToThreshold);
                if (!(diff > 0.0f)) continue;
                float healAmount = diff;
                ServerScheduler.schedule(1, () -> entity.heal(healAmount));
            }
        }
    }
}

