/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.api.events.leveling.AbilityModeSwitchEvent;
import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.entities.relic.midnight_mantle.ConstellationStarEntity;
import it.hurts.sskirillss.relics.entities.relic.midnight_mantle.FallingStarEntity;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import top.theillusivec4.curios.api.SlotContext;

public class MidnightMantleItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("phase").modes("full_moon", "new_moon").rankModifier(1, "switch").stat(StatTemplate.builder("attack_damage").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("attack_speed").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("max_health").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0727).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("health_regeneration").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0727).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("duration").initialValue(5.0, 10.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("modifier").initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("health_regeneration").modeVisibilityState("full_moon", VisibilityState.HIDDEN).build()).source(ExperienceSourceTemplate.builder("damage_dealing").modeVisibilityState("new_moon", VisibilityState.HIDDEN).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("duration_new_moon").formatValue(value -> MathUtils.formatTime(value.intValue())).modeVisibilityState("full_moon", VisibilityState.HIDDEN).build()).metric(AbilityMetricTemplate.builder("duration_full_moon").formatValue(value -> MathUtils.formatTime(value.intValue())).modeVisibilityState("new_moon", VisibilityState.HIDDEN).build()).metric(AbilityMetricTemplate.builder("additional_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).modeVisibilityState("new_moon", VisibilityState.HIDDEN).build()).metric(AbilityMetricTemplate.builder("health_regeneration").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).modeVisibilityState("full_moon", VisibilityState.HIDDEN).build()).build()).research(ResearchTemplate.builder().star(0, 6, 10).star(1, 16, 10).star(2, 6, 21).star(3, 16, 21).link(0, 1).link(1, 3).link(3, 2).link(2, 0).build()).build()).ability(AbilityTemplate.builder("invisibility").requiredLevel(5).rankModifier(3, "strike").stat(StatTemplate.builder("brightness").thresholdValue(0.0, 1.0).initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0545).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("cooldown").thresholdValue(0.0, Double.MAX_VALUE).initialValue(15.0, 10.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), -0.01636).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("damage").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("being_invisible").build()).source(ExperienceSourceTemplate.builder("damage_dealing").rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("duration").formatValue(value -> MathUtils.formatTime(value.intValue())).build()).metric(AbilityMetricTemplate.builder("additional_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 11, 6).star(1, 11, 10).star(2, 3, 16).star(3, 11, 16).star(4, 19, 16).star(5, 11, 21).star(6, 11, 25).link(3, 1).link(3, 2).link(3, 4).link(3, 5).link(1, 4).link(4, 5).link(5, 2).link(2, 1).link(1, 0).link(5, 6).build()).build()).ability(AbilityTemplate.builder("constellation").requiredLevel(10).rankModifier(5, "stun").stat(StatTemplate.builder("star_chance").initialValue(0.1, 0.2).thresholdValue(0.0, 1.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.1739).formatValue(value -> (int)MathUtils.round(value * 100.0, 1)).build()).stat(StatTemplate.builder("constellation_radius").thresholdValue(0.0, Double.MAX_VALUE).initialValue(5.0, 7.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0468).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("tremor_duration").initialValue(0.25, 1.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("explosion_radius").initialValue(0.5, 1.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1182).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("explosion_damage").initialValue(1.0, 5.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("star_lifetime").initialValue(10.0, 15.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1273).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("stun_duration").initialValue(1.0, 2.5).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 1.8632).formatValue(value -> MathUtils.round(value, 1)).build()).research(ResearchTemplate.builder().star(0, 17, 4).star(1, 5, 9).star(2, 20, 15).star(3, 6, 20).link(0, 1).link(1, 2).link(2, 3).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("star_creation").build()).source(ExperienceSourceTemplate.builder("star_tremor").build()).source(ExperienceSourceTemplate.builder("star_damage").build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("total_stars").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("star_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("star_stun").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("stun", VisibilityState.OBFUSCATED).build()).build()).build()).ability(AbilityTemplate.builder("starfall").requiredLevel(15).rankModifier(7, "bounce").stat(StatTemplate.builder("chance").thresholdValue(0.0, 1.0).initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0364).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("radius").initialValue(1.0, 2.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0727).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("damage").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1636).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("stun").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.3455).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("bounce_chance").initialValue(0.05, 0.15).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0424).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).research(ResearchTemplate.builder().star(0, 11, 4).star(1, 3, 11).star(2, 11, 11).star(3, 19, 11).star(4, 11, 18).star(5, 17, 21).star(6, 12, 23).star(7, 8, 26).link(2, 0).link(2, 1).link(2, 3).link(2, 4).link(0, 3).link(3, 4).link(4, 1).link(1, 0).link(4, 6).link(6, 5).link(6, 7).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("star_creation").build()).source(ExperienceSourceTemplate.builder("shockwave_hit").build()).source(ExperienceSourceTemplate.builder("star_bounce").rankModifierVisibilityState("bounce", VisibilityState.OBFUSCATED).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("total_stars").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("shockwave_targets").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("shockwave_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("shockwave_stun").formatValue(value -> MathUtils.formatTime(value.intValue())).build()).metric(AbilityMetricTemplate.builder("star_bounces").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).rankModifierVisibilityState("bounce", VisibilityState.OBFUSCATED).build()).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(1000.0).maxRank(7).step(100.0).build()).loot(LootTemplate.builder().entry(LootEntries.THE_END, LootEntries.END_LIKE).build()).build();
    }

    public int getInvisibilityCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)RelicsDataComponents.MIDNIGHT_MANTLE_INVISIBILITY_COOLDOWN.get(), (Object)0);
    }

    public void setInvisibilityCooldown(ItemStack stack, int cooldown) {
        stack.set((DataComponentType)RelicsDataComponents.MIDNIGHT_MANTLE_INVISIBILITY_COOLDOWN.get(), (Object)cooldown);
    }

    public void addInvisibilityCooldown(ItemStack stack, int cooldown) {
        this.setInvisibilityCooldown(stack, this.getInvisibilityCooldown(stack) + cooldown);
    }

    public int getPhaseDuration(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.MIDNIGHT_MANTLE_PHASE_DURATION, (Object)0);
    }

    public void setPhaseDuration(ItemStack stack, int duration) {
        stack.set(RelicsDataComponents.MIDNIGHT_MANTLE_PHASE_DURATION, (Object)Math.max(duration, 0));
    }

    public void addPhaseDuration(ItemStack stack, int duration) {
        this.setPhaseDuration(stack, this.getPhaseDuration(stack) + duration);
    }

    public double getModeEffectiveness(LivingEntity entity, ItemStack stack) {
        if (!this.canPlayerUseAbility(entity, stack, "phase")) {
            return 0.0;
        }
        String mode = this.getAbilityMode(entity, stack, "phase");
        Level level = entity.getCommandSenderWorld();
        if (mode.isEmpty() || level.isDay()) {
            return 0.0;
        }
        int newMoonPhase = 4;
        int selectedPhase = mode.equals("new_moon") ? newMoonPhase : 0;
        int currentPhase = level.getMoonPhase();
        int directDistance = Math.abs(currentPhase - selectedPhase);
        int wrappedDistance = 8 - directDistance;
        int minDistance = Math.min(directDistance, wrappedDistance);
        double effectiveness = 1.0 - (double)minDistance / 4.0;
        if (this.isAbilityRankModifierUnlocked(entity, stack, "phase", "switch") && this.getPhaseDuration(stack) > 0) {
            effectiveness *= 1.0 + this.getStatValue(entity, stack, "phase", "modifier");
        }
        return effectiveness;
    }

    public boolean canHideInTheDarkness(LivingEntity entity, ItemStack stack) {
        double maxSkyDarken;
        Level level = entity.getCommandSenderWorld();
        BlockPos pos = entity.blockPosition();
        int blockBrightness = level.getBrightness(LightLayer.BLOCK, pos);
        int skyBrightness = level.getBrightness(LightLayer.SKY, pos);
        int maxBrightness = level.getMaxLightLevel();
        int skyDarken = level.getSkyDarken();
        return ((1.0 - (double)skyDarken / (maxSkyDarken = 11.0)) * (double)skyBrightness + (double)blockBrightness) / ((double)maxBrightness * 2.0) <= this.getStatValue(entity, stack, "invisibility", "brightness");
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (this.canPlayerUseAbility(entity, stack, "phase")) {
            String mode = this.getAbilityMode(entity, stack, "phase");
            if (!mode.isEmpty()) {
                if (entity.tickCount % 20 == 0) {
                    this.addAbilityMetricValue(entity, stack, "phase", "duration_" + mode, 1.0);
                }
                double totalEffectiveness = this.getModeEffectiveness(entity, stack);
                double attackEffectiveness = mode.equals("full_moon") ? totalEffectiveness : 0.0;
                double healEffectiveness = mode.equals("new_moon") ? totalEffectiveness : 0.0;
                EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.ATTACK_SPEED, (float)(this.getStatValue(entity, stack, "phase", "attack_speed") * attackEffectiveness), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH, (float)(this.getStatValue(entity, stack, "phase", "max_health") * healEffectiveness), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            }
            if (this.isAbilityRankModifierUnlocked(entity, stack, "phase", "switch") && this.getPhaseDuration(stack) > 0) {
                this.addPhaseDuration(stack, -1);
            }
        }
        if (this.canPlayerUseAbility(entity, stack, "invisibility")) {
            int cooldown = this.getInvisibilityCooldown(stack);
            if (cooldown > 0) {
                if (level.getEntitiesOfClass(Mob.class, entity.getBoundingBox().inflate(16.0)).stream().noneMatch(mob -> mob.getTarget() == entity && mob.hasLineOfSight((Entity)entity))) {
                    this.addInvisibilityCooldown(stack, -1);
                }
            } else if (this.canHideInTheDarkness(entity, stack)) {
                entity.addEffect(new MobEffectInstance(RelicsMobEffects.VANISHING, 5, 0, false, false));
                if (entity.tickCount % 20 == 0) {
                    this.addAbilityMetricValue(entity, stack, "invisibility", "duration", 1.0);
                    this.addRelicExperience(entity, stack, "invisibility", "being_invisible", 1.0);
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.ATTACK_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @EventBusSubscriber
    public static class CommonEvents {
        private static void onInteract(LivingEntity entity) {
            if (entity.getCommandSenderWorld().isClientSide()) {
                return;
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "invisibility")) continue;
                ServerScheduler.schedule(1, () -> relic.setInvisibilityCooldown(stack, (int)(relic.getStatValue(entity, stack, "invisibility", "cooldown") * 20.0)));
            }
        }

        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            BlockPos max;
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            AABB box = entity.getBoundingBox();
            BlockPos min = BlockPos.containing((double)(Math.floor(box.minX) - 1.0), (double)Math.floor(box.minY), (double)(Math.floor(box.minZ) - 1.0));
            if (!level.hasChunksAt(min, max = BlockPos.containing((double)(Math.floor(box.maxX) + 1.0), (double)(Math.floor(entity.getEyeY()) + 1.0), (double)(Math.floor(box.maxZ) + 1.0)))) {
                return;
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "phase") || !relic.getAbilityMode(entity, stack, "phase").equals("new_moon")) continue;
                double heal = (double)event.getAmount() * relic.getStatValue(entity, stack, "phase", "health_regeneration") * relic.getModeEffectiveness(entity, stack);
                event.setAmount((float)((double)event.getAmount() + heal));
                if (entity.level().isClientSide()) continue;
                relic.addAbilityMetricValue(entity, stack, "phase", "health_regeneration", heal);
                relic.addRelicExperience(entity, stack, "phase", "health_regeneration", heal);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt1(LivingIncomingDamageEvent event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "phase") || !relic.getAbilityMode(entity2, stack, "phase").equals("full_moon")) continue;
                double damage = (double)event.getAmount() * relic.getStatValue(entity2, stack, "phase", "attack_damage") * relic.getModeEffectiveness(entity2, stack);
                event.setAmount((float)((double)event.getAmount() + damage));
                if (entity2.level().isClientSide()) continue;
                relic.addAbilityMetricValue(entity2, stack, "phase", "additional_damage", damage);
                relic.addRelicExperience(entity2, stack, "phase", "damage_dealing", damage);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt2(LivingIncomingDamageEvent event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "invisibility") || !relic.isAbilityRankModifierUnlocked(entity2, stack, "invisibility", "strike") || relic.getInvisibilityCooldown(stack) > 0 || !relic.canHideInTheDarkness(entity2, stack)) continue;
                double damage = (double)event.getAmount() * relic.getStatValue(entity2, stack, "invisibility", "damage");
                event.setAmount((float)((double)event.getAmount() + damage));
                if (!entity2.level().isClientSide()) {
                    relic.addAbilityMetricValue(entity2, stack, "invisibility", "additional_damage", damage);
                    relic.addRelicExperience(entity2, stack, "invisibility", "damage_dealing", damage);
                }
                relic.setInvisibilityCooldown(stack, (int)relic.getStatValue(entity2, stack, "invisibility", "cooldown"));
            }
        }

        @SubscribeEvent
        public static void onLivingHurt3(LivingIncomingDamageEvent event) {
            CommonEvents.onInteract(event.getEntity());
        }

        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            CommonEvents.onInteract((LivingEntity)event.getEntity());
        }

        @SubscribeEvent
        public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            CommonEvents.onInteract((LivingEntity)event.getEntity());
        }

        @SubscribeEvent
        public static void onBlockBreakAttempt(PlayerEvent.BreakSpeed event) {
            CommonEvents.onInteract((LivingEntity)event.getEntity());
        }

        @SubscribeEvent
        public static void onAttackEntity(AttackEntityEvent event) {
            CommonEvents.onInteract((LivingEntity)event.getEntity());
        }

        @SubscribeEvent
        public static void onItemToss(ItemTossEvent event) {
            CommonEvents.onInteract((LivingEntity)event.getPlayer());
        }

        @SubscribeEvent
        public static void onItemPickup(ItemEntityPickupEvent.Post event) {
            CommonEvents.onInteract((LivingEntity)event.getPlayer());
        }

        @SubscribeEvent
        public static void onAbilityModeSwitch(AbilityModeSwitchEvent event) {
            LivingEntity entity = event.getEntity();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "phase") || !relic.isAbilityRankModifierUnlocked(entity, stack, "phase", "switch")) continue;
                relic.setPhaseDuration(stack, (int)relic.getStatValue(entity, stack, "phase", "duration") * 20);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt4(LivingDamageEvent.Post event) {
            Entity entity;
            if ((double)event.getOriginalDamage() < 1.0 || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity source = (LivingEntity)entity;
            LivingEntity entity2 = event.getEntity();
            if (source.getStringUUID().equals(entity2.getStringUUID())) {
                return;
            }
            Level level = entity2.level();
            RandomSource random = level.getRandom();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "constellation") || random.nextDouble() > relic.getStatValue(entity2, stack, "constellation", "star_chance")) continue;
                ConstellationStarEntity star = new ConstellationStarEntity((EntityType<? extends ConstellationStarEntity>)((EntityType)RelicsEntities.CONSTELLATION_STAR.get()), level);
                star.setDeltaMovement(MathUtils.randomFloat(random) * 0.5f, 0.1f + random.nextFloat() * 0.1f, MathUtils.randomFloat(random) * 0.5f);
                star.setConstellationRadius((float)relic.getStatValue(entity2, stack, "constellation", "constellation_radius"));
                star.setExplosionRadius((float)relic.getStatValue(entity2, stack, "constellation", "explosion_radius"));
                star.setDamage((float)relic.getStatValue(entity2, stack, "constellation", "explosion_damage"));
                star.setTremor((float)relic.getStatValue(entity2, stack, "constellation", "tremor_duration"));
                star.setLifetime((int)relic.getStatValue(entity2, stack, "constellation", "star_lifetime"));
                star.setFlawless(relic.isRelicFlawless(entity2, stack));
                star.setPos(entity2.getEyePosition());
                star.setOwner((Entity)entity2);
                star.setStack(stack);
                if (relic.isAbilityRankModifierUnlocked(entity2, stack, "constellation", "stun")) {
                    star.setStun((float)relic.getStatValue(entity2, stack, "constellation", "stun_duration"));
                }
                level.addFreshEntity((Entity)star);
                if (level.isClientSide()) continue;
                relic.addAbilityMetricValue(entity2, stack, "constellation", "total_stars", 1.0);
                relic.addRelicExperience(entity2, stack, "constellation", "star_creation", 1.0);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt5(LivingIncomingDamageEvent event) {
            Entity entity;
            if ((double)event.getAmount() < 1.0 || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            LivingEntity target = event.getEntity();
            if (target.getStringUUID().equals(entity2.getStringUUID())) {
                return;
            }
            Level level = entity2.level();
            RandomSource random = level.getRandom();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.MIDNIGHT_MANTLE.get())) {
                Vec3 pos;
                MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "starfall") || (double)random.nextFloat() > relic.getStatValue(entity2, stack, "starfall", "chance") || level.clip(new ClipContext(pos = new Vec3(target.getX() + (double)(MathUtils.randomFloat(random) * 10.0f), target.getY() + 25.0 + (double)random.nextInt(25), target.getZ() + (double)(MathUtils.randomFloat(random) * 10.0f)), target.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target)).getType() != HitResult.Type.MISS) continue;
                Vec3 motion = target.position().subtract(pos).normalize().scale(2.0);
                FallingStarEntity star = new FallingStarEntity((EntityType<? extends FallingStarEntity>)((EntityType)RelicsEntities.FALLING_STAR.get()), level);
                star.setDamage((float)((double)event.getAmount() * relic.getStatValue(entity2, stack, "starfall", "damage")));
                star.setRadius((int)Math.round(relic.getStatValue(entity2, stack, "starfall", "radius")));
                star.setStun((int)(relic.getStatValue(entity2, stack, "starfall", "stun") * 20.0));
                star.setFlawless(relic.isRelicFlawless(entity2, stack));
                star.setDeltaMovement(motion);
                star.setOwner((Entity)entity2);
                star.setStack(stack);
                star.setPos(pos);
                if (relic.isAbilityRankModifierUnlocked(entity2, stack, "starfall", "bounce")) {
                    star.setBounceChance((float)relic.getStatValue(entity2, stack, "starfall", "bounce_chance"));
                }
                level.addFreshEntity((Entity)star);
                if (level.isClientSide()) continue;
                relic.addAbilityMetricValue(entity2, stack, "starfall", "total_stars", 1.0);
                relic.addRelicExperience(entity2, stack, "starfall", "star_creation", 1.0);
            }
        }
    }
}

