/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.style.base.RelicStyle;
import it.hurts.sskirillss.relics.init.RelicsRelicStyles;
import it.hurts.sskirillss.relics.items.ItemBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class RelicItem
extends ItemBase
implements ICurioItem,
IRelicItem {
    public RelicItem(Item.Properties properties) {
        super(properties);
    }

    public RelicItem() {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1));
    }

    @Deprecated(forRemoval=true)
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        RelicAttributeModifier attributes = this.getRelicAttributeModifiers(slotContext.entity(), stack);
        RelicSlotModifier slots = this.getSlotModifiers(slotContext.entity(), stack);
        if (attributes != null) {
            attributes.getAttributes().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$0((Multimap)modifiers, stack, slotContext, arg_0));
        }
        if (slots != null) {
            slots.getModifiers().forEach((arg_0, arg_1) -> RelicItem.lambda$getAttributeModifiers$1((Multimap)modifiers, id, arg_0, arg_1));
        }
        return modifiers;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        return new ArrayList<Component>();
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public String getConfigRoute() {
        return "relics";
    }

    public Component getName(ItemStack stack) {
        Component base = super.getName(stack);
        String text = base.getString();
        if (text.isEmpty()) {
            return base;
        }
        Optional<RelicStyle> optional = RelicsRelicStyles.getStyle(this);
        if (optional.isEmpty()) {
            return base;
        }
        List<OctoColor> colors = optional.get().getItemNameColors(null, stack);
        if (colors.isEmpty()) {
            return base;
        }
        MutableComponent result = Component.empty();
        int length = text.length();
        float spread = Math.max(1.0f, (float)length * 1.25f);
        float speed = 1.0f;
        float time = (float)System.nanoTime() * 1.0E-9f;
        int colorCount = colors.size();
        for (int i = 0; i < length; ++i) {
            float x = (float)i / spread - time * speed;
            float tri = 1.0f - Math.abs(x % 2.0f - 1.0f);
            float w = 0.5f - 0.5f * (float)Math.cos((double)tri * Math.PI);
            float scaled = w * (float)(colorCount - 1);
            int idx1 = (int)Math.floor(scaled);
            int idx2 = (idx1 + 1) % colorCount;
            float localT = scaled - (float)idx1;
            OctoColor color = colors.get(idx1).lerp(colors.get(idx2), (double)localT);
            int rgb = color.getARGB() & 0xFFFFFF;
            result.append((Component)Component.literal((String)String.valueOf(text.charAt(i))).setStyle(base.getStyle().withColor(TextColor.fromRgb((int)rgb))));
        }
        return result;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap modifiers, ResourceLocation id, String slot, Integer count) {
        CuriosApi.addSlotModifier((Multimap)modifiers, (String)slot, (ResourceLocation)id, (double)count.intValue(), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap modifiers, ItemStack stack, SlotContext slotContext, RelicAttributeModifier.Modifier attribute) {
        modifiers.put(attribute.getAttribute(), (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + "_" + BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.getAttribute().value())).getPath() + "_" + slotContext.identifier() + "_" + slotContext.index())), (double)attribute.getMultiplier(), attribute.getOperation()));
    }
}

