/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.leveling;

import it.hurts.sskirillss.relics.api.scaling_models.ScalingModel;
import it.hurts.sskirillss.relics.config.data.LevelingConfigData;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import lombok.Generated;

public class LevelingTemplate {
    private final ScalingModel scalingModel;
    private final double initialCost;
    private final double step;
    private final int maxRank;

    public static LevelingTemplateBuilder builder() {
        return new LevelingTemplateBuilder();
    }

    public LevelingTemplateBuilder toBuilder() {
        return new LevelingTemplateBuilder(this);
    }

    public LevelingConfigData toConfigData() {
        return new LevelingConfigData(this.initialCost, this.step);
    }

    @Generated
    public ScalingModel getScalingModel() {
        return this.scalingModel;
    }

    @Generated
    public double getInitialCost() {
        return this.initialCost;
    }

    @Generated
    public double getStep() {
        return this.step;
    }

    @Generated
    public int getMaxRank() {
        return this.maxRank;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelingTemplate)) {
            return false;
        }
        LevelingTemplate other = (LevelingTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getInitialCost(), other.getInitialCost()) != 0) {
            return false;
        }
        if (Double.compare(this.getStep(), other.getStep()) != 0) {
            return false;
        }
        if (this.getMaxRank() != other.getMaxRank()) {
            return false;
        }
        ScalingModel this$scalingModel = this.getScalingModel();
        ScalingModel other$scalingModel = other.getScalingModel();
        return !(this$scalingModel == null ? other$scalingModel != null : !this$scalingModel.equals(other$scalingModel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LevelingTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialCost = Double.doubleToLongBits(this.getInitialCost());
        result = result * 59 + (int)($initialCost >>> 32 ^ $initialCost);
        long $step = Double.doubleToLongBits(this.getStep());
        result = result * 59 + (int)($step >>> 32 ^ $step);
        result = result * 59 + this.getMaxRank();
        ScalingModel $scalingModel = this.getScalingModel();
        result = result * 59 + ($scalingModel == null ? 43 : $scalingModel.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LevelingTemplate(scalingModel=" + String.valueOf(this.getScalingModel()) + ", initialCost=" + this.getInitialCost() + ", step=" + this.getStep() + ", maxRank=" + this.getMaxRank() + ")";
    }

    @Generated
    private LevelingTemplate(ScalingModel scalingModel, double initialCost, double step, int maxRank) {
        this.scalingModel = scalingModel;
        this.initialCost = initialCost;
        this.step = step;
        this.maxRank = maxRank;
    }

    public static class LevelingTemplateBuilder {
        private ScalingModel scalingModel = RelicsScalingModels.ADDITIVE.get();
        private double initialCost = 100.0;
        private double step = 100.0;
        private int maxRank = 5;

        private LevelingTemplateBuilder(LevelingTemplate base) {
            this.scalingModel = base.getScalingModel();
            this.initialCost = base.getInitialCost();
            this.step = base.getStep();
            this.maxRank = base.getMaxRank();
        }

        public LevelingTemplateBuilder scalingModel(ScalingModel scalingModel) {
            this.scalingModel = scalingModel;
            return this;
        }

        public LevelingTemplateBuilder initialCost(double initialCost) {
            this.initialCost = initialCost;
            return this;
        }

        public LevelingTemplateBuilder step(double step) {
            this.step = step;
            return this;
        }

        public LevelingTemplateBuilder maxRank(int maxRank) {
            this.maxRank = maxRank;
            return this;
        }

        public LevelingTemplate build() {
            return new LevelingTemplate(this.scalingModel, this.initialCost, this.step, this.maxRank);
        }

        @Generated
        public LevelingTemplateBuilder() {
        }
    }
}

