/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.item.kinetic_belt.C2SSetActive;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.SlotContext;

public class KineticBeltItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("slots").requiredPoints(2).initialMaxLevel(5).maxLevelRankModifier(0.1).stat(StatTemplate.builder("amount").initialValue(1.0, 2.0).upgradeModifier(RelicsScalingModels.ADDITIVE.get(), 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).research(ResearchTemplate.builder().star(0, 11, 2).star(1, 5, 6).star(2, 17, 6).star(3, 2, 10).star(4, 20, 10).star(5, 11, 11).star(6, 2, 17).star(7, 7, 17).star(8, 15, 17).star(9, 20, 17).star(10, 2, 24).star(11, 20, 24).star(12, 11, 25).link(0, 1).link(0, 2).link(2, 5).link(1, 5).link(5, 7).link(5, 8).link(7, 12).link(8, 12).link(7, 3).link(7, 6).link(7, 10).link(8, 4).link(8, 9).link(8, 11).build()).build()).ability(AbilityTemplate.builder("gliding").rankModifier(1, "momentum").rankModifier(3, "strike").rankModifier(5, "resistance").modes("enabled", "disabled").stat(StatTemplate.builder("efficiency").initialValue(0.25, 0.35).thresholdValue(0.0, 1.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0531).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("damage").initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.2571).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("resistance").initialValue(0.05, 0.15).thresholdValue(0.0, 0.75).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1143).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("gliding").modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).source(ExperienceSourceTemplate.builder("strike").modeVisibilityState("disabled", VisibilityState.HIDDEN).rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("resistance").modeVisibilityState("disabled", VisibilityState.HIDDEN).rankModifierVisibilityState("resistance", VisibilityState.OBFUSCATED).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("duration").formatValue(value -> MathUtils.formatTime(value.intValue())).modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).metric(AbilityMetricTemplate.builder("damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).metric(AbilityMetricTemplate.builder("resistance").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("resistance", VisibilityState.OBFUSCATED).modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).build()).research(ResearchTemplate.builder().star(0, 2, 9).star(1, 20, 9).star(2, 5, 13).star(3, 17, 13).star(4, 11, 14).star(5, 2, 18).star(6, 20, 18).star(7, 5, 19).star(8, 11, 19).star(9, 17, 19).star(10, 7, 26).star(11, 15, 26).link(8, 4).link(8, 2).link(8, 3).link(8, 10).link(8, 11).link(2, 7).link(2, 0).link(0, 5).link(3, 9).link(3, 1).link(1, 6).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(100.0).build()).loot(LootTemplate.builder().entry(LootEntries.THE_END).entry(LootEntries.END_LIKE).build()).build();
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.set(RelicsDataComponents.KINETIC_BELT_ACTIVE, (Object)active);
    }

    public boolean isActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RelicsDataComponents.KINETIC_BELT_ACTIVE, (Object)false);
    }

    public void setLanded(ItemStack stack, boolean landed) {
        stack.set(RelicsDataComponents.KINETIC_BELT_LANDED, (Object)landed);
    }

    public boolean isLanded(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RelicsDataComponents.KINETIC_BELT_LANDED, (Object)false);
    }

    @Override
    public RelicSlotModifier getSlotModifiers(LivingEntity entity, ItemStack stack) {
        return RelicSlotModifier.builder().modifier("charm", (int)Math.round(this.getStatValue(entity, stack, "slots", "amount"))).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        if (!this.canPlayerUseAbility(entity, stack, "gliding") || this.getAbilityMode(entity, stack, "gliding").equals("disabled")) {
            return;
        }
        Level level = entity.level();
        RandomSource random = level.getRandom();
        boolean isActive = this.isActive(stack);
        boolean isLanded = this.isLanded(stack);
        boolean onGround = entity.onGround();
        boolean hasAttribute = EntityUtils.hasAttribute(entity, stack, (Holder<Attribute>)Attributes.GRAVITY);
        if (level.isClientSide() && entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            if (player.input.jumping && !player.isFallFlying() && !player.getAbilities().flying && !player.isSwimming()) {
                NetworkHandler.sendToServer(new C2SSetActive(slotContext.identifier(), slotContext.index(), true));
            } else if (isActive) {
                NetworkHandler.sendToServer(new C2SSetActive(slotContext.identifier(), slotContext.index(), false));
            }
        }
        if (isLanded) {
            if (this.isAbilityRankModifierUnlocked(entity, stack, "gliding", "momentum") && !onGround && isActive) {
                this.setLanded(stack, false);
            }
        } else if (onGround && !isActive) {
            this.setLanded(stack, true);
        }
        Vec3 motion = entity.getDeltaMovement();
        float verticalMotion = (float)(-motion.y);
        float minVy = 0.25f;
        float maxVy = 7.5f;
        float baseSlowFactor = Math.clamp((maxVy - verticalMotion) / (maxVy - minVy), 0.0f, 1.0f);
        float slowFactor = (float)Math.sqrt(baseSlowFactor);
        float maxReductionPerTick = 1.0f;
        float reduction = maxReductionPerTick * slowFactor;
        entity.fallDistance = Math.max(entity.fallDistance - reduction, 0.1f);
        if (isActive) {
            if (entity.tickCount % 20 == 0) {
                this.addAbilityMetricValue(entity, stack, "gliding", "duration", 1.0);
                this.addRelicExperience(entity, stack, "gliding", "gliding", 1.0);
            }
            if (!hasAttribute) {
                EntityUtils.applyAttribute(entity, stack, (Holder<Attribute>)Attributes.GRAVITY, (float)(-Math.min(this.getStatValue(entity, stack, "gliding", "efficiency"), (double)0.9f)), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            }
            Vec3 prevPosition = new Vec3(entity.xOld, entity.yOld, entity.zOld);
            Vec3 position = entity.getPosition(0.25f);
            Vec3 movementDelta = position.subtract(prevPosition);
            double distance = movementDelta.length();
            double spawnStep = 0.025;
            int spawnCount = (int)(distance / spawnStep) + 1;
            double yawRadians = Math.toRadians(entity.yBodyRot);
            Vec3 forward = new Vec3(-Math.sin(yawRadians), 0.0, Math.cos(yawRadians)).normalize();
            Vec3 right = forward.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            Vec3 left = right.scale(-1.0);
            double sideOffset = 0.4;
            double backOffset = 0.2;
            for (int i = 0; i <= spawnCount; ++i) {
                double t = spawnCount == 0 ? 0.0 : (double)i / (double)spawnCount;
                Vec3 basePosition = prevPosition.add(movementDelta.scale(t)).subtract(forward.scale(backOffset));
                double centerX = basePosition.x;
                double centerY = basePosition.y + (double)(entity.getBbHeight() / 2.0f) - (double)0.15f;
                double centerZ = basePosition.z;
                for (Vec3 side : new Vec3[]{right, left}) {
                    double x = centerX + side.x * sideOffset + (random.nextDouble() * 2.0 - 1.0) * 0.02;
                    double y = centerY + (random.nextDouble() * 2.0 - 1.0) * 0.02;
                    double z = centerZ + side.z * sideOffset + (random.nextDouble() * 2.0 - 1.0) * 0.02;
                    float vx = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    float vy = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    float vz = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                    level.addParticle(ParticleUtils.constructSimpleSpark(this.isRelicFlawless(entity, stack) ? new Color(200 + random.nextInt(50), 150 + random.nextInt(50), 0) : new Color(random.nextInt(50), 75 + random.nextInt(100), 255), 0.1f + random.nextFloat() * 0.15f, 100 + random.nextInt(20), 0.995f), x, y, z, (double)vx, (double)vy, (double)vz);
                }
            }
        } else if (hasAttribute) {
            EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            LivingEntity entity = event.getEntity();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.KINETIC_BELT.get())) {
                KineticBeltItem relic = (KineticBeltItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "gliding") || relic.getAbilityMode(entity, stack, "gliding").equals("disabled") || !relic.isAbilityRankModifierUnlocked(entity, stack, "gliding", "momentum") || !relic.isActive(stack)) continue;
                event.setDistance(0.0f);
                break;
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent.Pre event) {
            Projectile projectile;
            LivingEntity entity = event.getEntity();
            float original = event.getNewDamage();
            Object object = event.getSource().getDirectEntity();
            if (object instanceof Projectile && (object = (projectile = (Projectile)object).getOwner()) instanceof LivingEntity) {
                LivingEntity source = (LivingEntity)object;
                for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)source, (Item)RelicsItems.KINETIC_BELT.get())) {
                    KineticBeltItem relic = (KineticBeltItem)stack.getItem();
                    if (!relic.canPlayerUseAbility(source, stack, "gliding") || relic.getAbilityMode(entity, stack, "gliding").equals("disabled") || !relic.isAbilityRankModifierUnlocked(source, stack, "gliding", "strike") || !relic.isActive(stack)) continue;
                    double additional = (double)original * relic.getStatValue(entity, stack, "gliding", "damage");
                    relic.addRelicExperience(entity, stack, "gliding", "strike", additional);
                    relic.addAbilityMetricValue(entity, stack, "gliding", "damage", additional);
                    event.setNewDamage((float)((double)original + additional));
                }
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.KINETIC_BELT.get())) {
                KineticBeltItem relic = (KineticBeltItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "gliding") || relic.getAbilityMode(entity, stack, "gliding").equals("disabled") || !relic.isAbilityRankModifierUnlocked(entity, stack, "gliding", "resistance") || !relic.isActive(stack)) continue;
                double additional = (double)original * relic.getStatValue(entity, stack, "gliding", "resistance");
                relic.addRelicExperience(entity, stack, "gliding", "resistance", additional);
                relic.addAbilityMetricValue(entity, stack, "gliding", "resistance", additional);
                event.setNewDamage((float)((double)original - additional));
            }
        }
    }
}

