/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.EntityBlockSpeedFactorEvent;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.item.roller_skate.C2SCreateSpark;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;

public class RollerSkateItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("skating").rankModifier(1, "step_height").rankModifier(3, "resistance").rankModifier(5, "sparkling").stat(StatTemplate.builder("speed").initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.6279).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("step_height").initialValue(0.6, 1.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0571).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("resistance").initialValue(0.1, 0.25).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0857).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("damage").initialValue(1.0, 2.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0857).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("ignite").initialValue(1.0, 2.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1143).formatValue(value -> MathUtils.round(value, 1)).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("distance_traveled").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("damage_resisted").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("resistance", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("sparks_created").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).rankModifierVisibilityState("sparkling", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("damage_dealt").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("sparkling", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("ignite_duration").formatValue(value -> MathUtils.formatTime(value.intValue())).rankModifierVisibilityState("sparkling", VisibilityState.OBFUSCATED).build()).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("skating").build()).source(ExperienceSourceTemplate.builder("resisting_damage").rankModifierVisibilityState("resistance", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("creating_sparks").rankModifierVisibilityState("sparkling", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("spark_hit").rankModifierVisibilityState("sparkling", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 3, 7).star(1, 13, 9).star(2, 6, 16).star(3, 16, 18).star(4, 9, 25).star(5, 15, 29).link(5, 4).link(4, 2).link(2, 0).link(2, 1).link(4, 3).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(200.0).build()).loot(LootTemplate.builder().entry(LootEntries.OVERWORLD).build()).build();
    }

    public int getDuration(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.ROLLER_SKATE_DURATION, (Object)0);
    }

    public void setDuration(ItemStack stack, int duration) {
        stack.set(RelicsDataComponents.ROLLER_SKATE_DURATION, (Object)Math.clamp((long)duration, 0, this.getMaxDuration()));
    }

    public void addDuration(ItemStack stack, int progress) {
        this.setDuration(stack, this.getDuration(stack) + progress);
    }

    public int getMaxDuration() {
        return 100;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = livingEntity;
        Level level = entity.level();
        RandomSource random = level.getRandom();
        int duration = this.getDuration(stack);
        if (entity.isSprinting() && entity.onGround() && !entity.isInLiquid() && !entity.isFallFlying()) {
            double movement;
            if (duration < this.getMaxDuration()) {
                this.addDuration(stack, 1);
            }
            if ((movement = entity.getKnownMovement().multiply(1.0, 0.0, 1.0).length()) > 0.0) {
                this.addRelicExperience(entity, stack, "skating", "skating", 0.05);
                this.addAbilityMetricValue(entity, stack, "skating", "distance_traveled", movement);
            }
        } else if (duration > 0) {
            this.addDuration(stack, -1);
        }
        if (duration > 0) {
            EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, (float)(this.getStatValue(entity, stack, "skating", "speed") / (double)this.getMaxDuration() * (double)this.getDuration(stack)), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            if (this.isAbilityRankModifierUnlocked(entity, stack, "skating", "step_height")) {
                EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, (float)this.getStatValue(entity, stack, "skating", "step_height"), AttributeModifier.Operation.ADD_VALUE);
            }
        }
        if (this.isAbilityRankModifierUnlocked(entity, stack, "skating", "sparkling")) {
            Vec3 motion = entity.getDeltaMovement();
            double xMotion = motion.x;
            double zMotion = motion.z;
            float speed = Mth.sqrt((float)((float)(xMotion * xMotion + zMotion * zMotion)));
            if (speed > 0.25f && entity.onGround()) {
                float yawRad = entity.getYRot() * (float)Math.PI / 180.0f;
                float inputX = entity.xxa;
                float inputZ = entity.zza;
                float inLen = Mth.sqrt((float)(inputX * inputX + inputZ * inputZ));
                if (inLen > 0.01f) {
                    float directionZ;
                    double dot;
                    inputX /= inLen;
                    float directionX = (inputZ /= inLen) * -Mth.sin((float)yawRad) + inputX * Mth.cos((float)yawRad);
                    if ((dot = (double)directionX * (xMotion / (double)speed) + (double)(directionZ = inputZ * Mth.cos((float)yawRad) + inputX * Mth.sin((float)yawRad)) * (zMotion / (double)speed)) < 0.75) {
                        int count = Mth.clamp((int)((int)(speed * 10.0f)), (int)1, (int)20);
                        for (int i = 0; i < count; ++i) {
                            float force = (0.25f + random.nextFloat() * 0.25f) * speed * 2.0f;
                            float offset = MathUtils.randomFloat(random) * 0.35f;
                            float deltaX = -directionX * force + -directionZ * offset;
                            float deltaY = 0.2f + random.nextFloat() * 0.2f * speed;
                            float deltaZ = -directionZ * force + directionX * offset;
                            NetworkHandler.sendToServer(new C2SCreateSpark(slotContext.identifier(), slotContext.index(), entity.position().toVector3f(), new Vector3f(deltaX, deltaY, deltaZ), entity.getStringUUID(), (float)(this.getStatValue(entity, stack, "skating", "damage") * (double)speed), (float)(this.getStatValue(entity, stack, "skating", "ignite") * (double)speed), this.isRelicFlawless(entity, stack)));
                        }
                    }
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE);
    }

    @EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.isInLiquid() || entity.isFallFlying() || !entity.onGround()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)RelicsItems.ROLLER_SKATE.get());
            if (stack.isEmpty()) {
                return;
            }
            RollerSkateItem relic = (RollerSkateItem)stack.getItem();
            float base = 0.6f;
            float max = 1.0f;
            float diff = max - base;
            float modifier = diff / (float)relic.getMaxDuration() * (float)relic.getDuration(stack);
            event.setFriction(base + modifier);
        }

        @SubscribeEvent
        public static void onSpeedFactor(EntityBlockSpeedFactorEvent event) {
            LivingEntity entity;
            Entity entity2 = event.getEntity();
            if (!(entity2 instanceof LivingEntity) || (entity = (LivingEntity)entity2).isInLiquid() || entity.isFallFlying() || !entity.onGround()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)RelicsItems.ROLLER_SKATE.get());
            if (stack.isEmpty()) {
                return;
            }
            event.setSpeedFactor(1.0f);
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent.Pre event) {
            LivingEntity entity = event.getEntity();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.ROLLER_SKATE.get())) {
                float original = event.getOriginalDamage();
                RollerSkateItem relic = (RollerSkateItem)stack.getItem();
                int duration = relic.getDuration(stack);
                if (!relic.canPlayerUseAbility(entity, stack, "skating") || !relic.isAbilityRankModifierUnlocked(entity, stack, "skating", "resistance") || duration <= 0) continue;
                float modifier = (float)((double)original * (relic.getStatValue(entity, stack, "skating", "resistance") * (double)((float)duration / (float)relic.getMaxDuration())));
                event.setNewDamage(original - modifier);
                relic.addAbilityMetricValue(entity, stack, "skating", "damage_resisted", modifier);
                relic.addRelicExperience(entity, stack, "skating", "resisting_damage", modifier);
            }
        }
    }
}

