/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.head;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.entities.GoldenToothEntity;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PiglinMaskItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("neutrality").rankModifier(1, "legion").initialMaxLevel(0).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("target").rankModifierVisibilityState("legion", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 6, 9).star(1, 16, 9).star(2, 11, 12).star(3, 3, 15).star(4, 19, 15).star(5, 11, 23).link(2, 1).link(1, 4).link(4, 5).link(5, 3).link(3, 0).link(0, 2).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("target").formatValue(value -> String.valueOf(value.intValue())).rankModifierVisibilityState("legion", VisibilityState.OBFUSCATED).build()).build()).build()).ability(AbilityTemplate.builder("barter").rankModifier(3, "pocket").stat(StatTemplate.builder("trades").initialValue(1.0, 3.0).upgradeModifier(RelicsScalingModels.ADDITIVE.get(), 0.25).formatValue(Double::intValue).build()).stat(StatTemplate.builder("items_count").initialValue(1.0, 4.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.4286).formatValue(Double::intValue).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("trade").build()).source(ExperienceSourceTemplate.builder("pickup").rankModifierVisibilityState("pocket", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 9, 7).star(1, 17, 13).star(2, 7, 20).link(0, 1).link(1, 2).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("currency").formatValue(value -> String.valueOf(value.intValue())).build()).metric(AbilityMetricTemplate.builder("items").formatValue(value -> String.valueOf(value.intValue())).build()).build()).build()).ability(AbilityTemplate.builder("looting").requiredLevel(5).rankModifier(5, "frenzy").stat(StatTemplate.builder("chance").initialValue(0.1, 0.15).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1143).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("health").initialValue(10.0, 7.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), -0.019).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("duration").initialValue(5.0, 10.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 5.5811).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("attack_damage").initialValue(0.005, 0.01).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0571).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).stat(StatTemplate.builder("attack_speed").initialValue(0.005, 0.01).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1714).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("drop").build()).source(ExperienceSourceTemplate.builder("stack").rankModifierVisibilityState("frenzy", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 12, 8).star(1, 4, 13).star(2, 13, 17).star(3, 18, 19).star(4, 14, 22).link(2, 3).link(3, 0).link(0, 1).link(1, 4).link(4, 2).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("teeth_dropped").formatValue(value -> String.valueOf(value.intValue())).build()).metric(AbilityMetricTemplate.builder("teeth_picked_up").formatValue(value -> String.valueOf(value.intValue())).build()).metric(AbilityMetricTemplate.builder("additional_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("frenzy", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("effect_duration").formatValue(value -> MathUtils.formatTime(value.intValue())).rankModifierVisibilityState("frenzy", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("tripled_effect_duration").formatValue(value -> MathUtils.formatTime(value.intValue())).rankModifierVisibilityState("frenzy", VisibilityState.OBFUSCATED).build()).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(100.0).build()).loot(LootTemplate.builder().entry(LootEntries.BASTION).build()).build();
    }

    public int getStacks(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.PIGLIN_MASK_STACKS, (Object)0);
    }

    public void setStacks(ItemStack stack, int stacks) {
        stack.set(RelicsDataComponents.PIGLIN_MASK_STACKS, (Object)Math.clamp((long)stacks, 0, PiglinMaskItem.getMaxStacks()));
    }

    public void addStacks(ItemStack stack, int stacks) {
        this.setStacks(stack, this.getStacks(stack) + stacks);
    }

    public static int getMaxStacks() {
        return 32;
    }

    public int getDuration(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.PIGLIN_MASK_DURATION, (Object)0);
    }

    public void setDuration(LivingEntity entity, ItemStack stack, int duration) {
        stack.set(RelicsDataComponents.PIGLIN_MASK_DURATION, (Object)Math.clamp((long)duration, 0, this.getMaxDuration(entity, stack)));
    }

    public void addDuration(LivingEntity entity, ItemStack stack, int duration) {
        this.setDuration(entity, stack, this.getDuration(stack) + duration);
    }

    public int getMaxDuration(LivingEntity entity, ItemStack stack) {
        return (int)this.getStatValue(entity, stack, "looting", "duration");
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        int duration = this.getDuration(stack);
        int stacks = this.getStacks(stack);
        if (entity.tickCount % 20 == 0) {
            if (duration > 0 || stacks > 0) {
                this.addAbilityMetricValue(entity, stack, "looting", "effect_duration", 1.0);
                if (stacks >= PiglinMaskItem.getMaxStacks()) {
                    this.addAbilityMetricValue(entity, stack, "looting", "tripled_effect_duration", 1.0);
                }
            }
            if (duration > 0) {
                this.addDuration(entity, stack, -1);
            } else if (stacks > 0) {
                if (stacks >= PiglinMaskItem.getMaxStacks()) {
                    this.setStacks(stack, 0);
                } else {
                    this.addStacks(stack, -1);
                }
            }
            int modifier = stacks >= PiglinMaskItem.getMaxStacks() ? 3 : 1;
            EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.ATTACK_SPEED, (float)((double)stacks * this.getStatValue(entity, stack, "looting", "attack_speed") * (double)modifier), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.ATTACK_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.canPlayerUseAbility(slotContext.entity(), stack, "neutrality");
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingDamage1(LivingDamageEvent.Post event) {
            LivingEntity source;
            LivingEntity target;
            block5: {
                block4: {
                    target = event.getEntity();
                    Entity entity = event.getSource().getEntity();
                    if (!(entity instanceof LivingEntity)) break block4;
                    source = (LivingEntity)entity;
                    if (!(target instanceof AbstractPiglin)) break block5;
                }
                return;
            }
            Level level = source.level();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)source, (Item)RelicsItems.PIGLIN_MASK.get())) {
                PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
                if (!relic.isAbilityRankModifierUnlocked(source, stack, "neutrality", "legion")) continue;
                for (Mob piglin : level.getEntitiesOfClass(Mob.class, source.getBoundingBox().inflate(32.0), mob -> mob instanceof Piglin || mob instanceof ZombifiedPiglin)) {
                    if (piglin.getTarget() != null || !piglin.hasLineOfSight((Entity)target) || piglin.isBaby()) continue;
                    relic.addRelicExperience(source, stack, "neutrality", "target", 1.0);
                    relic.addAbilityMetricValue(target, stack, "neutrality", "target", 1.0);
                    piglin.getBrain().setMemory(MemoryModuleType.ANGRY_AT, (Object)target.getUUID());
                    piglin.setTarget(target);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamage2(LivingDamageEvent.Post event) {
            Entity source = event.getSource().getEntity();
            LivingEntity target = event.getEntity();
            if (source == null) {
                return;
            }
            Level level = source.level();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)target, (Item)RelicsItems.PIGLIN_MASK.get())) {
                PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
                if (!relic.isAbilityRankModifierUnlocked(target, stack, "neutrality", "legion")) continue;
                for (Mob piglin : level.getEntitiesOfClass(Mob.class, target.getBoundingBox().inflate(32.0), mob -> mob instanceof Piglin || mob instanceof ZombifiedPiglin)) {
                    if (piglin.getTarget() != null || !piglin.hasLineOfSight(source) || piglin.isBaby()) continue;
                    relic.addRelicExperience(target, stack, "neutrality", "target", 1.0);
                    relic.addAbilityMetricValue(target, stack, "neutrality", "target", 1.0);
                    piglin.getBrain().setMemory(MemoryModuleType.ANGRY_AT, (Object)source.getUUID());
                    if (!(source instanceof LivingEntity)) continue;
                    piglin.setTarget((LivingEntity)source);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamage3(LivingDamageEvent.Pre event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity source = (LivingEntity)entity;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)source, (Item)RelicsItems.PIGLIN_MASK.get())) {
                PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
                if (!relic.isAbilityRankModifierUnlocked(source, stack, "looting", "frenzy")) continue;
                float damage = event.getNewDamage();
                int stacks = relic.getStacks(stack);
                int multiplier = stacks >= PiglinMaskItem.getMaxStacks() ? 3 : 1;
                double modifier = (double)damage * relic.getStatValue(source, stack, "looting", "attack_damage") * (double)stacks * (double)multiplier;
                event.setNewDamage((float)((double)damage + modifier));
                relic.addAbilityMetricValue(source, stack, "looting", "additional_damage", modifier);
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity source = (LivingEntity)entity;
            LivingEntity entity2 = event.getEntity();
            Level level = source.level();
            RandomSource random = level.getRandom();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)source, (Item)RelicsItems.PIGLIN_MASK.get())) {
                PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
                if (!relic.canPlayerUseAbility(source, stack, "looting")) continue;
                int amount = MathUtils.multicast(random, relic.getStatValue(source, stack, "looting", "chance"), (int)Math.ceil((double)entity2.getMaxHealth() / relic.getStatValue(source, stack, "looting", "health")));
                relic.addAbilityMetricValue(source, stack, "looting", "teeth_dropped", amount);
                for (int i = 0; i < amount; ++i) {
                    GoldenToothEntity tooth = new GoldenToothEntity((EntityType<? extends GoldenToothEntity>)((EntityType)RelicsEntities.GOLDEN_TOOTH.get()), level);
                    tooth.setStacks(1);
                    tooth.setPos(entity2.getEyePosition());
                    tooth.setDeltaMovement(MathUtils.randomFloat(random) * 0.35f, 0.25f + random.nextFloat() * 0.25f, MathUtils.randomFloat(random) * 0.35f);
                    level.addFreshEntity((Entity)tooth);
                    relic.addRelicExperience(source, stack, "looting", "drop", 1.0);
                }
            }
        }
    }
}

