/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.entities.ShockwaveBlockEntity;
import it.hurts.sskirillss.relics.entities.SpringyBootShockwaveBlockEntity;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.items.relics.feet.SpringyBootItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.S2CSpawnParticle;
import it.hurts.sskirillss.relics.network.packets.item.springy_boot.S2CBounceFromSurface;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"fallOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onEntityFall(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean mayContinue = false;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)livingEntity, (Item)RelicsItems.SPRINGY_BOOT.get())) {
            SpringyBootItem relic;
            Item item = stack.getItem();
            if (!(item instanceof SpringyBootItem) || !(relic = (SpringyBootItem)item).isLeaped(stack)) continue;
            if (!livingEntity.level().isClientSide()) {
                if (livingEntity.getKnownMovement().y() > -0.75) {
                    relic.setLeaped(stack, false);
                    relic.setLeaps(stack, 0);
                } else if (livingEntity.isShiftKeyDown()) {
                    relic.setLeaped(stack, false);
                    relic.setLeaps(stack, 0);
                }
            }
            mayContinue = true;
        }
        if (mayContinue) {
            livingEntity.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
            ci.cancel();
        }
    }

    @Inject(method={"updateEntityAfterFallOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onEntityFall(BlockGetter getter, Entity entity, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Level level = livingEntity.level();
        int waveIndex = 0;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)livingEntity, (Item)RelicsItems.SPRINGY_BOOT.get())) {
            Vec3 motion;
            double speed;
            SpringyBootItem relic;
            Item item = stack.getItem();
            if (!(item instanceof SpringyBootItem) || !(relic = (SpringyBootItem)item).isLeaped(stack)) continue;
            if (relic.getBounceCooldown(stack) <= 0 && !livingEntity.level().isClientSide() && (speed = (motion = livingEntity.getKnownMovement()).y()) <= -0.75) {
                relic.addBounceCooldown(stack, 5);
                relic.addLeaps(stack, 1);
                speed = Math.abs(speed);
                if (!livingEntity.isShiftKeyDown()) {
                    if (!level.isClientSide()) {
                        relic.addRelicExperience(livingEntity, stack, "bounce", "bounce", 1.0);
                        relic.addAbilityMetricValue(livingEntity, stack, "bounce", "secondary_bounces", 1.0);
                    }
                    level.playSound(null, livingEntity.blockPosition(), (SoundEvent)RelicsSounds.SPRING_BOING.get(), SoundSource.PLAYERS, (float)Math.clamp(0.5 + speed * 0.5, 0.5, 2.0), (float)Math.max((double)0.1f, 2.0 - speed * 0.75));
                    NetworkHandler.sendToClientsTrackingEntityAndSelf(new S2CBounceFromSurface(livingEntity.getId(), motion.multiply(1.0, -1.0, 1.0).toVector3f()), (Entity)livingEntity);
                } else if (relic.isAbilityRankModifierUnlocked(livingEntity, stack, "bounce", "shockwave")) {
                    int delayTicks = waveIndex * 20;
                    BlockPos center = livingEntity.blockPosition();
                    double verticalSpeed = Math.abs(livingEntity.getKnownMovement().y());
                    int radius = (int)Math.min(25L, Math.round((1.0 + relic.getStatValue(livingEntity, stack, "bounce", "radius")) * verticalSpeed));
                    float damage = (float)relic.getStatValue(livingEntity, stack, "bounce", "damage");
                    int stun = (int)relic.getStatValue(livingEntity, stack, "bounce", "stun") * 20;
                    relic.addRelicExperience(livingEntity, stack, "bounce", "create_shockwave", radius);
                    ServerScheduler.schedule(delayTicks, () -> {
                        relic.addAbilityMetricValue(livingEntity, stack, "bounce", "shockwaves_amount", 1.0);
                        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
                        for (int i = -radius; i <= radius; ++i) {
                            int r1 = (int)Mth.sqrt((float)(radius * radius - i * i));
                            for (int j = -r1; j <= r1; ++j) {
                                poses.add(center.offset(i, 0, j));
                            }
                        }
                        int step = 0;
                        while (step <= radius) {
                            int finalStep = step++;
                            ServerScheduler.schedule(finalStep, () -> {
                                float height = 0.25f;
                                Random localRandom = new Random();
                                poses.stream().filter(pos -> {
                                    int dz;
                                    int dx = pos.getX() - center.getX();
                                    double dist = Math.hypot(dx, dz = pos.getZ() - center.getZ());
                                    return dist >= (double)finalStep && dist < (double)(finalStep + 1);
                                }).forEach(entryPos -> {
                                    int centerY = center.getY();
                                    int maxOffset = 8;
                                    int groundY = WorldUtils.findSurfaceY(level, entryPos.getX(), entryPos.getZ(), centerY, maxOffset);
                                    int minAllowedY = Math.max(level.getMinBuildHeight(), centerY - maxOffset);
                                    int maxAllowedY = Math.min(level.getMaxBuildHeight(), centerY + maxOffset);
                                    if (groundY < minAllowedY || groundY > maxAllowedY) {
                                        return;
                                    }
                                    BlockPos surfacePos = new BlockPos(entryPos.getX(), groundY, entryPos.getZ());
                                    SpringyBootShockwaveBlockEntity shockwave = new SpringyBootShockwaveBlockEntity((EntityType<? extends ShockwaveBlockEntity>)((EntityType)RelicsEntities.SHOCKWAVE_BLOCK.get()), level);
                                    shockwave.setDamage(damage);
                                    shockwave.setStun(stun);
                                    shockwave.setPos((float)surfacePos.getX() + 0.5f, surfacePos.getY(), (float)surfacePos.getZ() + 0.5f);
                                    shockwave.setBlockState(level.getBlockState(surfacePos));
                                    shockwave.setDeltaMovement(0.0, height, 0.0);
                                    shockwave.setOwner((Entity)livingEntity);
                                    shockwave.setCenter(surfacePos);
                                    shockwave.setKnockback(1.0f);
                                    shockwave.setStack(stack);
                                    level.addFreshEntity((Entity)shockwave);
                                    double angle = (double)localRandom.nextFloat() * Math.PI * 2.0;
                                    float rad = (float)finalStep + 0.5f + (localRandom.nextFloat() - 0.5f) * 0.3f;
                                    float px = (float)((double)surfacePos.getX() + Math.cos(angle) * (double)rad + 0.5);
                                    float py = (float)surfacePos.getY() + 1.5f + localRandom.nextFloat() * 0.2f;
                                    float pz = (float)((double)surfacePos.getZ() + Math.sin(angle) * (double)rad + 0.5);
                                    float vx = (float)Math.cos(angle) * 0.2f;
                                    float vy = 0.025f + localRandom.nextFloat() * 0.05f;
                                    float vz = (float)Math.sin(angle) * 0.2f;
                                    NetworkHandler.sendToClientsTrackingEntity(new S2CSpawnParticle((ParticleOptions)ParticleTypes.CLOUD, new Vector3f(px, py, pz), new Vector3f(vx, vy, vz)), (Entity)shockwave);
                                });
                            });
                        }
                    });
                    ++waveIndex;
                }
            }
            ci.cancel();
        }
    }
}

