/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GuiGraphics.class})
public class GuiGraphicsMixin {
    @Unique
    private static final ResourceLocation UPGRADE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/item_state/upgrade.png");
    @Unique
    private static final ResourceLocation RESEARCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/item_state/research.png");

    @Inject(method={"renderTooltipInternal"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void onTooltipRender(Font font, List<ClientTooltipComponent> tooltip, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info, RenderTooltipEvent.Pre event, int width, int height, int postWidth, int postHeight, Vector2ic postPos) {
        if (!tooltip.isEmpty()) {
            NeoForge.EVENT_BUS.post((Event)new TooltipDisplayEvent(event.getItemStack(), (GuiGraphics)this, postWidth, postHeight, postPos.x(), postPos.y()));
        }
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", shift=At.Shift.AFTER)})
    public void renderItemDecorations(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        GuiGraphics guiGraphics = (GuiGraphics)this;
        PoseStack poseStack = guiGraphics.pose();
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float time = (float)stack.getItem().hashCode() / 1000.0f + (float)player.tickCount + partialTicks;
        float color = (float)(1.0 + Math.sin(time * 0.45f) * (double)0.1f);
        boolean renderedUpgradeIcon = false;
        boolean renderedResearchIcon = false;
        for (AbilityTemplate ability : relic.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().values()) {
            if (!renderedUpgradeIcon && relic.mayUpgrade((LivingEntity)player, stack, ability.getId())) {
                poseStack.pushPose();
                poseStack.translate((float)(x + 9), (float)(y - 2), 200.0f);
                poseStack.translate(4.5f, 4.5f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotation((float)(Math.sin(time * 0.35f) * (double)0.15f)));
                poseStack.translate(-4.5f, -4.5f, 0.0f);
                GUIRenderer.begin(UPGRADE_TEXTURE, poseStack).color(color, color, color, 1.0f).anchor(SpriteAnchor.TOP_LEFT).end();
                poseStack.popPose();
                renderedUpgradeIcon = true;
            }
            if (renderedResearchIcon || !relic.mayResearch((LivingEntity)player, stack, ability.getId()) && !relic.mayUnlock((LivingEntity)player, stack, ability.getId())) continue;
            poseStack.pushPose();
            poseStack.translate((float)(x + 9), (float)(y + 9), 200.0f);
            poseStack.translate(Math.sin(time * 0.25f) * 0.75, Math.cos(time * 0.25f) * 0.75, 0.0);
            RenderSystem.enableBlend();
            GUIRenderer.begin(RESEARCH_TEXTURE, poseStack).color(color, color, color, 1.0f).anchor(SpriteAnchor.TOP_LEFT).end();
            RenderSystem.disableBlend();
            poseStack.popPose();
            renderedResearchIcon = true;
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V", shift=At.Shift.AFTER)})
    public void renderItem(LivingEntity entity, Level level, ItemStack stack, int x, int y, int seed, int guiOffset, CallbackInfo ci) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        GuiGraphics guiGraphics = (GuiGraphics)this;
        PoseStack poseStack = guiGraphics.pose();
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float time = (float)(seed + player.tickCount) + partialTicks;
        if (relic.isRelicFlawless((LivingEntity)player, stack)) {
            int beams = 8;
            for (int i = 0; i < beams; ++i) {
                float angle = (float)((double)((float)i * 2.0f) * Math.PI / (double)beams);
                poseStack.pushPose();
                poseStack.mulPose(Axis.ZP.rotation(angle));
                poseStack.mulPose(Axis.ZP.rotation(time * 0.025f));
                double length = (double)0.85f + (i % 2 == 0 ? Math.sin(time * 0.25f) : Math.cos(time * 0.25f)) * (double)0.1f;
                RenderUtils.renderFlatBeam(guiGraphics, partialTicks, (float)length, 0.45f, -256, 0xFF0000);
                poseStack.popPose();
            }
        }
    }
}

