/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsHotkeys;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void init(Item.Properties properties, CallbackInfo ci) {
        Item item = (Item)this;
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            RelicStorage.RELIC_TEMPLATES.put(relic, relic.getDefaultRelicTemplate());
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected, CallbackInfo ci) {
        Item item;
        LivingEntity livingEntity;
        block6: {
            block5: {
                if (level.isClientSide() || !(entity instanceof LivingEntity)) break block5;
                livingEntity = (LivingEntity)entity;
                item = stack.getItem();
                if (item instanceof IRelicItem) break block6;
            }
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (Map.Entry entry : relic.getAbilitiesTemplate(livingEntity, stack).getAbilities().entrySet()) {
            String ability = (String)entry.getKey();
            if (relic.getAbilityCooldown(livingEntity, stack, ability) <= 0) continue;
            relic.addAbilityCooldown(livingEntity, stack, ability, -1);
        }
        if (livingEntity.tickCount % 20 == 0) {
            relic.addRelicMetricValue(livingEntity, stack, "retention_time", 1.0);
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        this.relics$processTooltip(stack, context, tooltip);
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private void relics$processTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        tooltip.add((Component)Component.literal((String)" "));
        if (Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
            tooltip.add((Component)Component.translatable((String)"relics.description.researching.info", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName()}).withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.literal((String)" "));
    }

    @Inject(method={"verifyComponentsAfterLoad"}, at={@At(value="HEAD")})
    public void onVerifyComponentsAfterLoad(ItemStack stack, CallbackInfo ci) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (AbilityTemplate abilityData : relic.getDefaultAbilitiesTemplate().getAbilities().values()) {
            String abilityId = abilityData.getId();
            if (relic.getAbilityComponent(null, stack, abilityId) == null) {
                relic.randomizeAbilityStats(null, stack, abilityId);
                continue;
            }
            for (StatTemplate statData : relic.getDefaultAbilityTemplate(abilityId).getStats().values()) {
                String statId = statData.getId();
                if (relic.getStatComponent(null, stack, abilityId, statId) != null) continue;
                relic.randomizeStat(null, stack, abilityId, statId);
            }
        }
    }
}

