/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.belt.KineticBeltItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketSyncEntityEffects;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")})
    private void onJumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Vec3 motion = entity.getDeltaMovement();
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.KINETIC_BELT.get())) {
            KineticBeltItem relic = (KineticBeltItem)stack.getItem();
            if (!relic.canPlayerUseAbility(entity, stack, "gliding") || relic.getAbilityMode(entity, stack, "gliding").equals("disabled") || !relic.isActive(stack)) continue;
            double scale = relic.getStatValue(entity, stack, "gliding", "efficiency");
            entity.setDeltaMovement(motion.add(motion.scale(scale)));
        }
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=0.91f, ordinal=1)})
    private float removeAirDrag(float original) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().flying || player.isSpectator()) {
                return original;
            }
        }
        float maxValue = 0.985f;
        float diff = maxValue - original;
        float scale = (float)EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.KINETIC_BELT.get()).stream().filter(stack -> {
            KineticBeltItem relic = (KineticBeltItem)stack.getItem();
            return relic.canPlayerUseAbility(entity, (ItemStack)stack, "gliding") && !relic.getAbilityMode(entity, (ItemStack)stack, "gliding").equals("disabled") && (!relic.isLanded((ItemStack)stack) || relic.isActive((ItemStack)stack));
        }).mapToDouble(stack -> ((KineticBeltItem)stack.getItem()).getStatValue(entity, (ItemStack)stack, "gliding", "efficiency")).max().orElse(0.0);
        return original + diff * scale;
    }

    @ModifyVariable(method={"travel"}, name={"f2"}, index=8, ordinal=0, at=@At(value="STORE"))
    protected float setBlockFriction(float original) {
        LivingEntity entity = (LivingEntity)this;
        LivingSlippingEvent event = new LivingSlippingEvent(entity, entity.getCommandSenderWorld().getBlockState(entity.getOnPos()), original);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getFriction();
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isImmobile()Z")})
    protected boolean onAiStep(boolean original) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(RelicsMobEffects.STUN)) {
            return true;
        }
        if (entity.hasEffect(RelicsMobEffects.PARALYSIS)) {
            return true;
        }
        return original;
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="TAIL")})
    protected void onEffectAdded(MobEffectInstance effect, Entity target, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.getCommandSenderWorld();
        if (level.isClientSide()) {
            return;
        }
        NetworkHandler.sendToClientsTrackingEntity(new PacketSyncEntityEffects((CompoundTag)effect.save(), PacketSyncEntityEffects.Action.ADD, entity.getId()), (Entity)entity);
    }

    @Inject(method={"onEffectUpdated"}, at={@At(value="TAIL")})
    protected void onEffectUpdated(MobEffectInstance effect, boolean forced, Entity target, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.getCommandSenderWorld();
        if (level.isClientSide()) {
            return;
        }
        NetworkHandler.sendToClientsTrackingEntity(new PacketSyncEntityEffects((CompoundTag)effect.save(), PacketSyncEntityEffects.Action.UPDATE, entity.getId()), (Entity)entity);
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="TAIL")})
    protected void onEffectRemoved(MobEffectInstance effect, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.getCommandSenderWorld();
        if (level.isClientSide()) {
            return;
        }
        NetworkHandler.sendToClientsTrackingEntity(new PacketSyncEntityEffects((CompoundTag)effect.save(), PacketSyncEntityEffects.Action.REMOVE, entity.getId()), (Entity)entity);
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canBeSeenByAnyone(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(RelicsMobEffects.VANISHING)) {
            cir.setReturnValue((Object)false);
        }
    }
}

