/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.items.relics.head.PiglinMaskItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PiglinAi.class})
public abstract class PiglinAiMixin {
    @Shadow
    private static List<ItemStack> getBarterResponseItems(Piglin piglin) {
        return new ArrayList<ItemStack>();
    }

    @WrapOperation(method={"pickUpItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;removeOneItemFromItemEntity(Lnet/minecraft/world/entity/item/ItemEntity;)Lnet/minecraft/world/item/ItemStack;")})
    private static ItemStack wrapRemoveOne(ItemEntity itemEntity, Operation<ItemStack> operation, @Local(argsOnly=true) Piglin piglin) {
        Optional optional = piglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (optional.isEmpty()) {
            return (ItemStack)operation.call(new Object[]{itemEntity});
        }
        Player player = (Player)optional.get();
        ItemStack bestStack = ItemStack.EMPTY;
        int bestValue = 0;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)RelicsItems.PIGLIN_MASK.get())) {
            int value;
            PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
            if (!relic.isAbilityRankModifierUnlocked((LivingEntity)player, stack, "barter", "pocket") || (value = (int)relic.getStatValue((LivingEntity)player, stack, "barter", "items_count")) <= bestValue) continue;
            bestValue = value;
            bestStack = stack;
        }
        if (bestValue <= 0) {
            return (ItemStack)operation.call(new Object[]{itemEntity});
        }
        ItemStack stack = itemEntity.getItem();
        if (!stack.is(ItemTags.PIGLIN_LOVED)) {
            return (ItemStack)operation.call(new Object[]{itemEntity});
        }
        int toSplit = Math.min(stack.getCount(), bestValue);
        if (toSplit < 1) {
            return (ItemStack)operation.call(new Object[]{itemEntity});
        }
        ItemStack taken = stack.split(toSplit);
        if (stack.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(stack);
        }
        if (taken.getCount() > 1 && !bestStack.isEmpty()) {
            PiglinMaskItem relic = (PiglinMaskItem)bestStack.getItem();
            relic.addRelicExperience((LivingEntity)player, bestStack, "barter", "pickup", taken.getCount() - 1);
            relic.addAbilityMetricValue((LivingEntity)player, bestStack, "barter", "currency", taken.getCount());
        }
        return taken;
    }

    @Inject(method={"stopHoldingOffHandItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;throwItems(Lnet/minecraft/world/entity/monster/piglin/Piglin;Ljava/util/List;)V")}, cancellable=true)
    private static void tweakBartering(Piglin piglin, boolean bool, CallbackInfo ci, @Local ItemStack itemstack) {
        Optional optional = piglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (optional.isEmpty()) {
            return;
        }
        Player player = (Player)optional.get();
        RandomSource random = player.getRandom();
        int count = itemstack.is(ItemTags.PIGLIN_LOVED) ? itemstack.getCount() : 1;
        boolean shouldCancel = false;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)RelicsItems.PIGLIN_MASK.get())) {
            PiglinMaskItem relic = (PiglinMaskItem)stack.getItem();
            if (!relic.canPlayerUseAbility((LivingEntity)player, stack, "barter")) continue;
            shouldCancel = true;
            int base = random.nextInt((int)relic.getStatValue((LivingEntity)player, stack, "barter", "trades")) + 1;
            int total = Math.max(1, base) * count;
            for (int i = 0; i < total; ++i) {
                List<ItemStack> items = PiglinAiMixin.getBarterResponseItems(piglin);
                PiglinAi.throwItems((Piglin)piglin, items);
                int amount = 0;
                for (ItemStack tradeEntry : items) {
                    amount += tradeEntry.getCount();
                }
                relic.addAbilityMetricValue((LivingEntity)player, stack, "barter", "items", amount);
                relic.addRelicExperience((LivingEntity)player, stack, "barter", "trade", 1.0);
            }
        }
        if (shouldCancel) {
            ci.cancel();
        }
    }
}

