/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.abilities;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SpellCastPacket
implements CustomPacketPayload {
    private final CastType type;
    private final CastStage stage;
    private final CompoundTag ability;
    public static final CustomPacketPayload.Type<SpellCastPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"spell_cast"));
    public static final StreamCodec<ByteBuf, SpellCastPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper(CastType.BY_ID, CastType::getId), SpellCastPacket::getType, (StreamCodec)ByteBufCodecs.idMapper(CastStage.BY_ID, CastStage::getId), SpellCastPacket::getStage, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SpellCastPacket::getAbility, SpellCastPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            AbilityReference reference = new AbilityReference().deserializeNBT(this.ability);
            ItemStack stack = reference.getSlot().gatherStack(player);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            if (!relic.canPlayerUseAbility((LivingEntity)player, stack, reference.getId())) {
                if (relic.isAbilityTicking((LivingEntity)player, stack, reference.getId())) {
                    relic.setAbilityTicking((LivingEntity)player, stack, reference.getId(), false);
                    relic.castActiveAbility(player, stack, reference.getId(), this.type, CastStage.END);
                }
                return;
            }
            block0 : switch (this.type) {
                case CYCLICAL: 
                case TOGGLEABLE: {
                    switch (this.stage) {
                        case START: {
                            relic.setAbilityTicking((LivingEntity)player, stack, reference.getId(), true);
                            break block0;
                        }
                        case END: {
                            relic.setAbilityTicking((LivingEntity)player, stack, reference.getId(), false);
                        }
                    }
                }
            }
            relic.castActiveAbility(player, stack, reference.getId(), this.type, this.stage);
        });
    }

    @Generated
    public CastType getType() {
        return this.type;
    }

    @Generated
    public CastStage getStage() {
        return this.stage;
    }

    @Generated
    public CompoundTag getAbility() {
        return this.ability;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellCastPacket)) {
            return false;
        }
        SpellCastPacket other = (SpellCastPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CastType this$type = this.getType();
        CastType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CastStage this$stage = this.getStage();
        CastStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage)) {
            return false;
        }
        CompoundTag this$ability = this.getAbility();
        CompoundTag other$ability = other.getAbility();
        return !(this$ability == null ? other$ability != null : !this$ability.equals(other$ability));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpellCastPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CastType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CastStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        CompoundTag $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpellCastPacket(type=" + String.valueOf((Object)this.getType()) + ", stage=" + String.valueOf((Object)this.getStage()) + ", ability=" + String.valueOf(this.getAbility()) + ")";
    }

    @Generated
    public SpellCastPacket(CastType type, CastStage stage, CompoundTag ability) {
        this.type = type;
        this.stage = stage;
        this.ability = ability;
    }
}

