/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.item.roller_skate;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.entities.RollerSparkEntity;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.items.relics.feet.RollerSkateItem;
import it.hurts.sskirillss.relics.misc.stream_codec.ExtendedStreamCodec;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.CuriosApi;

public class C2SCreateSpark
implements CustomPacketPayload {
    private final String identifier;
    private final int index;
    private final Vector3f pos;
    private final Vector3f motion;
    private final String owner;
    private final float damage;
    private final float ignite;
    private final boolean flawless;
    public static final CustomPacketPayload.Type<C2SCreateSpark> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"roller_skate/create_spark"));
    public static final StreamCodec<ByteBuf, C2SCreateSpark> STREAM_CODEC = ExtendedStreamCodec.composite(ByteBufCodecs.STRING_UTF8, C2SCreateSpark::getIdentifier, ByteBufCodecs.INT, C2SCreateSpark::getIndex, ByteBufCodecs.VECTOR3F, C2SCreateSpark::getPos, ByteBufCodecs.VECTOR3F, C2SCreateSpark::getMotion, ByteBufCodecs.STRING_UTF8, C2SCreateSpark::getOwner, ByteBufCodecs.FLOAT, C2SCreateSpark::getDamage, ByteBufCodecs.FLOAT, C2SCreateSpark::getIgnite, ByteBufCodecs.BOOL, C2SCreateSpark::isFlawless, C2SCreateSpark::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level level = player.level();
            CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inventory -> inventory.findCurio(this.getIdentifier(), this.getIndex())).ifPresent(slot -> {
                ItemStack stack = slot.stack();
                RollerSkateItem relic = (RollerSkateItem)stack.getItem();
                RollerSparkEntity spark = new RollerSparkEntity((EntityType<? extends RollerSparkEntity>)((EntityType)RelicsEntities.ROLLER_SPARK.get()), level);
                spark.setDeltaMovement(this.motion.x(), this.motion.y(), this.motion.z());
                spark.setPos(this.pos.x(), this.pos.y(), this.pos.z());
                spark.setFlawless(this.flawless);
                spark.setDamage(this.damage);
                spark.setIgnite(this.ignite);
                spark.setStack(stack);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    spark.setOwner(serverLevel.getEntity(UUID.fromString(this.owner)));
                }
                level.addFreshEntity((Entity)spark);
                relic.addAbilityMetricValue((LivingEntity)player, stack, "skating", "sparks_created", 1.0);
                if (relic.getAbilityMetricValue((LivingEntity)player, stack, "skating", "sparks_created") % 10.0 == 0.0) {
                    relic.addRelicExperience((LivingEntity)player, stack, "skating", "creating_sparks", 1.0);
                }
            });
        });
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public Vector3f getPos() {
        return this.pos;
    }

    @Generated
    public Vector3f getMotion() {
        return this.motion;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public float getDamage() {
        return this.damage;
    }

    @Generated
    public float getIgnite() {
        return this.ignite;
    }

    @Generated
    public boolean isFlawless() {
        return this.flawless;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C2SCreateSpark)) {
            return false;
        }
        C2SCreateSpark other = (C2SCreateSpark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (Float.compare(this.getDamage(), other.getDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getIgnite(), other.getIgnite()) != 0) {
            return false;
        }
        if (this.isFlawless() != other.isFlawless()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Vector3f this$motion = this.getMotion();
        Vector3f other$motion = other.getMotion();
        if (this$motion == null ? other$motion != null : !this$motion.equals(other$motion)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof C2SCreateSpark;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + Float.floatToIntBits(this.getDamage());
        result = result * 59 + Float.floatToIntBits(this.getIgnite());
        result = result * 59 + (this.isFlawless() ? 79 : 97);
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Vector3f $motion = this.getMotion();
        result = result * 59 + ($motion == null ? 43 : $motion.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "C2SCreateSpark(identifier=" + this.getIdentifier() + ", index=" + this.getIndex() + ", pos=" + String.valueOf(this.getPos()) + ", motion=" + String.valueOf(this.getMotion()) + ", owner=" + this.getOwner() + ", damage=" + this.getDamage() + ", ignite=" + this.getIgnite() + ", flawless=" + this.isFlawless() + ")";
    }

    @Generated
    public C2SCreateSpark(String identifier, int index, Vector3f pos, Vector3f motion, String owner, float damage, float ignite, boolean flawless) {
        this.identifier = identifier;
        this.index = index;
        this.pos = pos;
        this.motion = motion;
        this.owner = owner;
        this.damage = damage;
        this.ignite = ignite;
        this.flawless = flawless;
    }
}

