/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import java.util.function.IntFunction;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketAbilityTweak
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final String ability;
    private final Operation operation;
    private final boolean withShift;
    public static final CustomPacketPayload.Type<PacketAbilityTweak> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"relic_tweak"));
    public static final StreamCodec<ByteBuf, PacketAbilityTweak> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketAbilityTweak::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketAbilityTweak::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketAbilityTweak::getAbility, (StreamCodec)ByteBufCodecs.idMapper(Operation.BY_ID, Operation::getId), PacketAbilityTweak::getOperation, (StreamCodec)ByteBufCodecs.BOOL, PacketAbilityTweak::isWithShift, PacketAbilityTweak::new);

    public PacketAbilityTweak(int container, int slot, String ability, Operation operation) {
        this(container, slot, ability, operation, false);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ItemStack stack;
            Player player;
            block16: {
                player = ctx.player();
                if (player.containerMenu.containerId != this.container) {
                    PacketAbilityTweak.causeError(player);
                    return;
                }
                stack = DescriptionUtils.gatherRelicStack(player, this.slot);
                Item patt0$temp = stack.getItem();
                if (!(patt0$temp instanceof IRelicItem)) {
                    PacketAbilityTweak.causeError(player);
                    return;
                }
                IRelicItem relic = (IRelicItem)patt0$temp;
                AbilityTemplate entry = relic.getAbilityTemplate((LivingEntity)player, stack, this.ability);
                if (entry == null) {
                    return;
                }
                switch (this.operation.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        boolean result = false;
                        if (this.withShift) {
                            while (relic.upgrade(player, stack, this.ability)) {
                                result = true;
                            }
                        } else {
                            result = relic.upgrade(player, stack, this.ability);
                        }
                        if (!result) break;
                        break block16;
                    }
                    case 2: {
                        boolean result = false;
                        if (this.withShift) {
                            while (relic.calculateAbilityQuality((LivingEntity)player, stack, this.ability) != relic.getAbilityMaxQuality((LivingEntity)player, stack, this.ability) && relic.reroll(player, stack, this.ability)) {
                                result = true;
                            }
                        } else {
                            result = relic.reroll(player, stack, this.ability);
                        }
                        if (!result) break;
                        break block16;
                    }
                    case 0: {
                        if (relic.reset(player, stack, this.ability)) break block16;
                    }
                }
                return;
            }
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketAbilityTweak.causeError(player);
            }
        });
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    @Generated
    public int getContainer() {
        return this.container;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public String getAbility() {
        return this.ability;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public boolean isWithShift() {
        return this.withShift;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketAbilityTweak)) {
            return false;
        }
        PacketAbilityTweak other = (PacketAbilityTweak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.isWithShift() != other.isWithShift()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        if (this$ability == null ? other$ability != null : !this$ability.equals(other$ability)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketAbilityTweak;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + (this.isWithShift() ? 79 : 97);
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PacketAbilityTweak(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", withShift=" + this.isWithShift() + ")";
    }

    @Generated
    public PacketAbilityTweak(int container, int slot, String ability, Operation operation, boolean withShift) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.operation = operation;
        this.withShift = withShift;
    }

    public static enum Operation {
        RESET(0),
        UPGRADE(1),
        REROLL(2);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

